/*
 * Decompiled with CFR 0.152.
 */
package wiremock.net.javacrumbs.jsonunit.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import wiremock.net.javacrumbs.jsonunit.core.Configuration;
import wiremock.net.javacrumbs.jsonunit.core.Option;
import wiremock.net.javacrumbs.jsonunit.core.internal.PathOption;

public class ConfigurationWhen {
    private ConfigurationWhen() {
    }

    public static PathsParam path(String path) {
        return new PathsParam(path);
    }

    public static PathsParam paths(String ... paths) {
        return new PathsParam(paths);
    }

    public static PathsParam rootPath() {
        return ConfigurationWhen.path("");
    }

    public static ApplicableForPath then(Option first, Option ... next) {
        return new OptionsParam(true, first, next);
    }

    public static ApplicableForPath thenNot(Option first, Option ... next) {
        return new OptionsParam(false, first, next);
    }

    public static ApplicableForPath thenIgnore() {
        return new IgnoredParam();
    }

    static class IgnoredParam
    implements ApplicableForPath {
        private IgnoredParam() {
        }

        @Override
        public Configuration applyForPaths(Configuration configuration, PathsParam pathsParam) {
            return configuration.whenIgnoringPaths(pathsParam.paths);
        }
    }

    static class OptionsParam
    implements ApplicableForPath {
        private final EnumSet<Option> options;
        private final boolean included;

        private OptionsParam(boolean included, Option first, Option ... next) {
            this.options = EnumSet.of(first, next);
            this.included = included;
        }

        @Override
        public Configuration applyForPaths(Configuration configuration, PathsParam pathsParam) {
            return configuration.addPathOption(new PathOption(pathsParam.getPaths(), this.options, this.included));
        }
    }

    public static interface ApplicableForPath {
        public Configuration applyForPaths(Configuration var1, PathsParam var2);
    }

    public static class PathsParam {
        private final List<String> paths;

        private PathsParam(String path) {
            this.paths = Collections.singletonList(path);
        }

        private PathsParam(String ... paths) {
            this.paths = Arrays.asList(paths);
        }

        List<String> getPaths() {
            return this.paths;
        }

        Configuration apply(Configuration configuration, ApplicableForPath action) {
            return action.applyForPaths(configuration, this);
        }
    }
}

