/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.client.http;

import java.util.Locale;
import java.util.concurrent.atomic.LongAdder;
import wiremock.org.eclipse.jetty.client.HttpChannel;
import wiremock.org.eclipse.jetty.client.HttpExchange;
import wiremock.org.eclipse.jetty.client.HttpRequest;
import wiremock.org.eclipse.jetty.client.HttpResponse;
import wiremock.org.eclipse.jetty.client.HttpResponseException;
import wiremock.org.eclipse.jetty.client.api.Response;
import wiremock.org.eclipse.jetty.client.api.Result;
import wiremock.org.eclipse.jetty.client.http.HttpConnectionOverHTTP;
import wiremock.org.eclipse.jetty.client.http.HttpConnectionUpgrader;
import wiremock.org.eclipse.jetty.client.http.HttpReceiverOverHTTP;
import wiremock.org.eclipse.jetty.client.http.HttpSenderOverHTTP;
import wiremock.org.eclipse.jetty.http.HttpFields;
import wiremock.org.eclipse.jetty.http.HttpHeader;
import wiremock.org.eclipse.jetty.http.HttpHeaderValue;
import wiremock.org.eclipse.jetty.http.HttpMethod;
import wiremock.org.eclipse.jetty.http.HttpVersion;

public class HttpChannelOverHTTP
extends HttpChannel {
    private final HttpConnectionOverHTTP connection;
    private final HttpSenderOverHTTP sender;
    private final HttpReceiverOverHTTP receiver;
    private final LongAdder inMessages = new LongAdder();
    private final LongAdder outMessages = new LongAdder();

    public HttpChannelOverHTTP(HttpConnectionOverHTTP connection) {
        super(connection.getHttpDestination());
        this.connection = connection;
        this.sender = this.newHttpSender();
        this.receiver = this.newHttpReceiver();
    }

    protected HttpSenderOverHTTP newHttpSender() {
        return new HttpSenderOverHTTP(this);
    }

    protected HttpReceiverOverHTTP newHttpReceiver() {
        return new HttpReceiverOverHTTP(this);
    }

    @Override
    protected HttpSenderOverHTTP getHttpSender() {
        return this.sender;
    }

    @Override
    protected HttpReceiverOverHTTP getHttpReceiver() {
        return this.receiver;
    }

    public HttpConnectionOverHTTP getHttpConnection() {
        return this.connection;
    }

    @Override
    public void send(HttpExchange exchange) {
        this.outMessages.increment();
        this.sender.send(exchange);
    }

    @Override
    public void release() {
        this.connection.release();
    }

    @Override
    public Result exchangeTerminating(HttpExchange exchange, Result result) {
        if (result.isFailed()) {
            return result;
        }
        HttpResponse response = exchange.getResponse();
        if (response.getVersion() == HttpVersion.HTTP_1_1 && response.getStatus() == 101) {
            String nextConnection = response.getHeaders().get(HttpHeader.CONNECTION);
            if (nextConnection == null || !nextConnection.toLowerCase(Locale.US).contains("upgrade")) {
                return new Result(result, new HttpResponseException("101 Switching Protocols without Connection: Upgrade not supported", response));
            }
            HttpRequest request = exchange.getRequest();
            HttpConnectionUpgrader upgrader = (HttpConnectionUpgrader)request.getConversation().getAttribute(HttpConnectionUpgrader.class.getName());
            if (upgrader != null) {
                try {
                    upgrader.upgrade(response, this.getHttpConnection());
                }
                catch (Throwable x) {
                    return new Result(result, x);
                }
            }
        }
        return result;
    }

    public void receive() {
        this.inMessages.increment();
        this.receiver.receive();
    }

    @Override
    public void exchangeTerminated(HttpExchange exchange, Result result) {
        super.exchangeTerminated(exchange, result);
        Response response = result.getResponse();
        HttpFields responseHeaders = response.getHeaders();
        String closeReason = null;
        if (result.isFailed()) {
            closeReason = "failure";
        } else if (this.receiver.isShutdown()) {
            closeReason = "server close";
        } else if (this.sender.isShutdown()) {
            closeReason = "client close";
        }
        if (closeReason == null) {
            if (response.getVersion().compareTo(HttpVersion.HTTP_1_1) < 0) {
                boolean keepAlive = responseHeaders.contains(HttpHeader.CONNECTION, HttpHeaderValue.KEEP_ALIVE.asString());
                boolean connect = HttpMethod.CONNECT.is(exchange.getRequest().getMethod());
                if (!keepAlive && !connect) {
                    closeReason = "http/1.0";
                }
            } else if (responseHeaders.contains(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE.asString())) {
                closeReason = "http/1.1";
            }
        }
        if (closeReason != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closing, reason: {} - {}", closeReason, this.connection);
            }
            this.connection.close();
        } else if (response.getStatus() == 101) {
            this.connection.remove();
        } else {
            this.release();
        }
    }

    protected long getMessagesIn() {
        return this.inMessages.longValue();
    }

    protected long getMessagesOut() {
        return this.outMessages.longValue();
    }

    @Override
    public String toString() {
        return String.format("%s[send=%s,recv=%s]", super.toString(), this.sender, this.receiver);
    }
}

