/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.client;

import wiremock.org.eclipse.jetty.client.DuplexConnectionPool;
import wiremock.org.eclipse.jetty.client.api.Connection;
import wiremock.org.eclipse.jetty.client.api.Destination;
import wiremock.org.eclipse.jetty.util.Callback;
import wiremock.org.eclipse.jetty.util.LeakDetector;
import wiremock.org.eclipse.jetty.util.log.Log;
import wiremock.org.eclipse.jetty.util.log.Logger;

public class LeakTrackingConnectionPool
extends DuplexConnectionPool {
    private static final Logger LOG = Log.getLogger(LeakTrackingConnectionPool.class);
    private final LeakDetector<Connection> leakDetector = new LeakDetector<Connection>(){

        @Override
        protected void leaked(LeakDetector.LeakInfo leakInfo) {
            LeakTrackingConnectionPool.this.leaked(leakInfo);
        }
    };

    public LeakTrackingConnectionPool(Destination destination, int maxConnections, Callback requester) {
        super(destination, maxConnections, requester);
        this.start();
    }

    private void start() {
        try {
            this.leakDetector.start();
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    @Override
    public void close() {
        this.stop();
        super.close();
    }

    private void stop() {
        try {
            this.leakDetector.stop();
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    @Override
    protected void acquired(Connection connection) {
        if (!this.leakDetector.acquired(connection)) {
            LOG.info("Connection {}@{} not tracked", connection, this.leakDetector.id(connection));
        }
    }

    @Override
    protected void released(Connection connection) {
        if (!this.leakDetector.released(connection)) {
            LOG.info("Connection {}@{} released but not acquired", connection, this.leakDetector.id(connection));
        }
    }

    protected void leaked(LeakDetector.LeakInfo leakInfo) {
        LOG.info("Connection " + leakInfo.getResourceDescription() + " leaked at:", leakInfo.getStackFrames());
    }
}

