/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.client;

import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.http.ChunkedDribbleDelay;
import com.github.tomakehurst.wiremock.http.DelayDistribution;
import com.github.tomakehurst.wiremock.http.Fault;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.LogNormal;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.http.UniformDistribution;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.google.common.collect.ImmutableList;
import wiremock.com.google.common.collect.Lists;
import wiremock.com.google.common.collect.Maps;

public class ResponseDefinitionBuilder {
    protected int status = 200;
    protected String statusMessage;
    protected byte[] binaryBody;
    protected JsonNode jsonBody;
    protected String stringBody;
    protected String base64Body;
    protected String bodyFileName;
    protected List<HttpHeader> headers = Lists.newArrayList();
    protected Integer fixedDelayMilliseconds;
    protected DelayDistribution delayDistribution;
    protected ChunkedDribbleDelay chunkedDribbleDelay;
    protected String proxyBaseUrl;
    protected Fault fault;
    protected List<String> responseTransformerNames;
    protected Map<String, Object> transformerParameters = Maps.newHashMap();
    protected Boolean wasConfigured = true;

    public static ResponseDefinitionBuilder like(ResponseDefinition responseDefinition) {
        ResponseDefinitionBuilder builder = new ResponseDefinitionBuilder();
        builder.status = responseDefinition.getStatus();
        builder.statusMessage = responseDefinition.getStatusMessage();
        builder.headers = responseDefinition.getHeaders() != null ? Lists.newArrayList(responseDefinition.getHeaders().all()) : Lists.newArrayList();
        builder.binaryBody = responseDefinition.getByteBodyIfBinary();
        builder.stringBody = responseDefinition.getBody();
        builder.base64Body = responseDefinition.getBase64Body();
        builder.jsonBody = responseDefinition.getJsonBody();
        builder.bodyFileName = responseDefinition.getBodyFileName();
        builder.fixedDelayMilliseconds = responseDefinition.getFixedDelayMilliseconds();
        builder.delayDistribution = responseDefinition.getDelayDistribution();
        builder.chunkedDribbleDelay = responseDefinition.getChunkedDribbleDelay();
        builder.proxyBaseUrl = responseDefinition.getProxyBaseUrl();
        builder.fault = responseDefinition.getFault();
        builder.responseTransformerNames = responseDefinition.getTransformers();
        builder.transformerParameters = responseDefinition.getTransformerParameters() != null ? Parameters.from(responseDefinition.getTransformerParameters()) : Parameters.empty();
        builder.wasConfigured = responseDefinition.isFromConfiguredStub();
        return builder;
    }

    public static ResponseDefinition jsonResponse(Object body) {
        return ResponseDefinitionBuilder.jsonResponse(body, 200);
    }

    public static ResponseDefinition jsonResponse(Object body, int status) {
        return new ResponseDefinitionBuilder().withBody(Json.write(body)).withStatus(status).withHeader("Content-Type", "application/json").build();
    }

    public ResponseDefinitionBuilder but() {
        return this;
    }

    public ResponseDefinitionBuilder withStatus(int status) {
        this.status = status;
        return this;
    }

    public ResponseDefinitionBuilder withHeader(String key, String ... values) {
        this.headers.add(new HttpHeader(key, values));
        return this;
    }

    public ResponseDefinitionBuilder withBodyFile(String fileName) {
        this.bodyFileName = fileName;
        return this;
    }

    public ResponseDefinitionBuilder withBody(String body) {
        this.stringBody = body;
        return this;
    }

    public ResponseDefinitionBuilder withBody(byte[] body) {
        this.binaryBody = body;
        return this;
    }

    public ResponseDefinitionBuilder withFixedDelay(Integer milliseconds) {
        this.fixedDelayMilliseconds = milliseconds;
        return this;
    }

    public ResponseDefinitionBuilder withRandomDelay(DelayDistribution distribution) {
        this.delayDistribution = distribution;
        return this;
    }

    public ResponseDefinitionBuilder withLogNormalRandomDelay(double medianMilliseconds, double sigma) {
        return this.withRandomDelay(new LogNormal(medianMilliseconds, sigma));
    }

    public ResponseDefinitionBuilder withUniformRandomDelay(int lowerMilliseconds, int upperMilliseconds) {
        return this.withRandomDelay(new UniformDistribution(lowerMilliseconds, upperMilliseconds));
    }

    public ResponseDefinitionBuilder withChunkedDribbleDelay(int numberOfChunks, int totalDuration) {
        this.chunkedDribbleDelay = new ChunkedDribbleDelay(numberOfChunks, totalDuration);
        return this;
    }

    public ResponseDefinitionBuilder withTransformers(String ... responseTransformerNames) {
        this.responseTransformerNames = Arrays.asList(responseTransformerNames);
        return this;
    }

    public ResponseDefinitionBuilder withTransformerParameter(String name, Object value) {
        this.transformerParameters.put(name, value);
        return this;
    }

    public ResponseDefinitionBuilder withTransformer(String transformerName, String parameterKey, Object parameterValue) {
        this.withTransformers(transformerName);
        this.withTransformerParameter(parameterKey, parameterValue);
        return this;
    }

    public ProxyResponseDefinitionBuilder proxiedFrom(String proxyBaseUrl) {
        this.proxyBaseUrl = proxyBaseUrl;
        return new ProxyResponseDefinitionBuilder(this);
    }

    public static ResponseDefinitionBuilder responseDefinition() {
        return new ResponseDefinitionBuilder();
    }

    public static <T> ResponseDefinitionBuilder okForJson(T body) {
        return ResponseDefinitionBuilder.responseDefinition().withStatus(200).withBody(Json.write(body)).withHeader("Content-Type", "application/json");
    }

    public static <T> ResponseDefinitionBuilder okForEmptyJson() {
        return ResponseDefinitionBuilder.responseDefinition().withStatus(200).withBody("{}").withHeader("Content-Type", "application/json");
    }

    public ResponseDefinitionBuilder withHeaders(HttpHeaders headers) {
        this.headers = ImmutableList.copyOf(headers.all());
        return this;
    }

    public ResponseDefinitionBuilder withBase64Body(String base64Body) {
        this.base64Body = base64Body;
        return this;
    }

    public ResponseDefinitionBuilder withStatusMessage(String message) {
        this.statusMessage = message;
        return this;
    }

    public ResponseDefinitionBuilder withFault(Fault fault) {
        this.fault = fault;
        return this;
    }

    public ResponseDefinition build() {
        return this.build(null);
    }

    private boolean isBinaryBody() {
        return this.binaryBody != null;
    }

    private boolean isJsonBody() {
        return this.jsonBody != null;
    }

    protected ResponseDefinition build(HttpHeaders additionalProxyRequestHeaders) {
        Parameters transformerParameters;
        HttpHeaders httpHeaders = this.headers == null || this.headers.isEmpty() ? null : new HttpHeaders(this.headers);
        Parameters parameters = transformerParameters = this.transformerParameters == null || this.transformerParameters.isEmpty() ? null : Parameters.from(this.transformerParameters);
        if (this.isBinaryBody()) {
            return new ResponseDefinition(this.status, this.statusMessage, this.binaryBody, null, this.base64Body, this.bodyFileName, httpHeaders, additionalProxyRequestHeaders, this.fixedDelayMilliseconds, this.delayDistribution, this.chunkedDribbleDelay, this.proxyBaseUrl, this.fault, this.responseTransformerNames, transformerParameters, this.wasConfigured);
        }
        if (this.isJsonBody()) {
            return new ResponseDefinition(this.status, this.statusMessage, this.binaryBody, this.jsonBody, null, this.bodyFileName, httpHeaders, additionalProxyRequestHeaders, this.fixedDelayMilliseconds, this.delayDistribution, this.chunkedDribbleDelay, this.proxyBaseUrl, this.fault, this.responseTransformerNames, transformerParameters, this.wasConfigured);
        }
        return new ResponseDefinition(this.status, this.statusMessage, this.stringBody, null, this.base64Body, this.bodyFileName, httpHeaders, additionalProxyRequestHeaders, this.fixedDelayMilliseconds, this.delayDistribution, this.chunkedDribbleDelay, this.proxyBaseUrl, this.fault, this.responseTransformerNames, transformerParameters, this.wasConfigured);
    }

    public static class ProxyResponseDefinitionBuilder
    extends ResponseDefinitionBuilder {
        private List<HttpHeader> additionalRequestHeaders = Lists.newArrayList();

        public ProxyResponseDefinitionBuilder(ResponseDefinitionBuilder from) {
            this.status = from.status;
            this.statusMessage = from.statusMessage;
            this.headers = from.headers;
            this.binaryBody = from.binaryBody;
            this.stringBody = from.stringBody;
            this.jsonBody = from.jsonBody;
            this.base64Body = from.base64Body;
            this.bodyFileName = from.bodyFileName;
            this.fault = from.fault;
            this.fixedDelayMilliseconds = from.fixedDelayMilliseconds;
            this.delayDistribution = from.delayDistribution;
            this.chunkedDribbleDelay = from.chunkedDribbleDelay;
            this.proxyBaseUrl = from.proxyBaseUrl;
            this.responseTransformerNames = from.responseTransformerNames;
            this.transformerParameters = from.transformerParameters;
        }

        public ProxyResponseDefinitionBuilder withAdditionalRequestHeader(String key, String value) {
            this.additionalRequestHeaders.add(new HttpHeader(key, value));
            return this;
        }

        @Override
        public ResponseDefinition build() {
            return !this.additionalRequestHeaders.isEmpty() ? super.build(new HttpHeaders(this.additionalRequestHeaders)) : super.build();
        }
    }
}

