/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.widget;

import android.content.res.ColorStateList;
import android.graphics.Color;
import android.support.design.widget.AnimationUtils;
import android.support.design.widget.AppBarLayout;
import android.support.design.widget.CollapsingToolbarLayout;
import android.support.design.widget.TabLayout;
import android.support.design.widget.ValueAnimatorCompat;
import android.support.design.widget.ViewUtils;
import android.support.v4.graphics.ColorUtils;
import android.support.v4.view.ViewCompat;
import android.view.View;

public class TabScrimHelper
implements AppBarLayout.OnOffsetChangedListener {
    private static final int DEFAULT_SCRIM_ANIMATION_DURATION = 600;
    private TabLayout mTabLayout;
    private CollapsingToolbarLayout mToolbarLayout;
    private long mScrimAnimationDuration;
    private int mScrimAlpha;
    private boolean mScrimsAreShown;
    private ValueAnimatorCompat mScrimAnimator;
    private final int mNormalColor;
    private final int mSelectedColor;
    private int mCollapseTabSelectTextColor;
    private int mCollapseTabNormalTextColor;
    private int mCollapseTabBackgroundColor;

    public TabScrimHelper(TabLayout tabLayout, CollapsingToolbarLayout toolbarLayout) {
        this.initDefault();
        this.mTabLayout = tabLayout;
        this.mToolbarLayout = toolbarLayout;
        ColorStateList colorStateList = this.mTabLayout.getTabTextColors();
        this.mSelectedColor = colorStateList.getColorForState(new int[]{0x10100A1}, Color.parseColor((String)"#3F51B5"));
        this.mNormalColor = colorStateList.getDefaultColor();
    }

    public void setCollapseTabBackgroundColor(int collapseTabBackgroundColor) {
        this.mCollapseTabBackgroundColor = collapseTabBackgroundColor;
    }

    public void setCollapseTabSelectTextColor(int collapseTabSelectTextColor) {
        this.mCollapseTabSelectTextColor = collapseTabSelectTextColor;
    }

    private void initDefault() {
        this.mScrimAnimationDuration = 600L;
        this.mCollapseTabBackgroundColor = Color.parseColor((String)"#3F51B5");
        this.mCollapseTabNormalTextColor = Color.parseColor((String)"#FFFFFF");
        this.mCollapseTabSelectTextColor = Color.parseColor((String)"#FF4081");
    }

    public void onOffsetChanged(AppBarLayout appBarLayout, int verticalOffset) {
        this.setScrimsShown(this.mToolbarLayout.getHeight() + verticalOffset < this.mToolbarLayout.getScrimVisibleHeightTrigger());
    }

    public void setScrimsShown(boolean shown) {
        this.setScrimsShown(shown, ViewCompat.isLaidOut((View)this.mToolbarLayout) && !this.mToolbarLayout.isInEditMode());
    }

    public void setScrimsShown(boolean shown, boolean animate) {
        if (this.mScrimsAreShown != shown) {
            if (animate) {
                this.animateScrim(shown ? 255 : 0);
            } else {
                this.setScrimAlpha(shown ? 255 : 0);
            }
            this.mScrimsAreShown = shown;
        }
    }

    private void animateScrim(int targetAlpha) {
        if (this.mScrimAnimator == null) {
            this.mScrimAnimator = ViewUtils.createAnimator();
            this.mScrimAnimator.setDuration(this.mScrimAnimationDuration);
            this.mScrimAnimator.setInterpolator(targetAlpha > this.mScrimAlpha ? AnimationUtils.FAST_OUT_LINEAR_IN_INTERPOLATOR : AnimationUtils.LINEAR_OUT_SLOW_IN_INTERPOLATOR);
            this.mScrimAnimator.addUpdateListener(new ValueAnimatorCompat.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimatorCompat animator) {
                    TabScrimHelper.this.setScrimAlpha(animator.getAnimatedIntValue());
                }
            });
        } else if (this.mScrimAnimator.isRunning()) {
            this.mScrimAnimator.cancel();
        }
        this.mScrimAnimator.setIntValues(this.mScrimAlpha, targetAlpha);
        this.mScrimAnimator.start();
    }

    void setScrimAlpha(int alpha) {
        if (alpha != this.mScrimAlpha) {
            this.mScrimAlpha = alpha;
            this.updateLayout();
        }
    }

    private void updateLayout() {
        int color = ColorUtils.setAlphaComponent((int)this.mCollapseTabBackgroundColor, (int)this.mScrimAlpha);
        this.mTabLayout.setBackgroundColor(color);
        float i = 1.0f * (float)this.mScrimAlpha / 255.0f;
        this.mTabLayout.setTabTextColors(ColorUtils.blendARGB((int)this.mNormalColor, (int)this.mCollapseTabNormalTextColor, (float)i), ColorUtils.blendARGB((int)this.mSelectedColor, (int)this.mCollapseTabSelectTextColor, (float)i));
    }
}

