/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.widget;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.os.Build;
import android.support.annotation.VisibleForTesting;
import android.support.design.widget.AnimationUtils;
import android.support.design.widget.AppBarLayout;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.MathUtils;
import android.support.design.widget.ValueAnimatorCompat;
import android.support.design.widget.ViewUtils;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import java.util.List;

public class AppBarLayoutSpringBehavior
extends AppBarLayout.Behavior {
    private static final int MAX_OFFSET_ANIMATION_DURATION = 600;
    private int mOffsetDelta;
    private int mOffsetSpring;
    private ValueAnimator mSpringRecoverAnimator;
    private int mPreHeadHeight;
    private SpringOffsetCallback mSpringOffsetCallback;
    private ValueAnimatorCompat mOffsetAnimator;

    public AppBarLayoutSpringBehavior() {
    }

    public AppBarLayoutSpringBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public boolean onStartNestedScroll(CoordinatorLayout parent, AppBarLayout child, View directTargetChild, View target, int nestedScrollAxes) {
        boolean started = super.onStartNestedScroll(parent, child, directTargetChild, target, nestedScrollAxes);
        if (started && this.mSpringRecoverAnimator != null && this.mSpringRecoverAnimator.isRunning()) {
            this.mSpringRecoverAnimator.cancel();
        }
        return started;
    }

    public void onStopNestedScroll(CoordinatorLayout coordinatorLayout, AppBarLayout abl, View target) {
        super.onStopNestedScroll(coordinatorLayout, abl, target);
        this.checkShouldSpringRecover(coordinatorLayout, abl);
    }

    private void checkShouldSpringRecover(CoordinatorLayout coordinatorLayout, AppBarLayout abl) {
        if (this.mOffsetSpring > 0) {
            this.animateRecoverBySpring(coordinatorLayout, abl);
        }
    }

    private void animateRecoverBySpring(final CoordinatorLayout coordinatorLayout, final AppBarLayout abl) {
        if (this.mSpringRecoverAnimator == null) {
            this.mSpringRecoverAnimator = new ValueAnimator();
            this.mSpringRecoverAnimator.setDuration(200L);
            this.mSpringRecoverAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            this.mSpringRecoverAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    AppBarLayoutSpringBehavior.this.updateSpringHeaderHeight(coordinatorLayout, abl, (Integer)animation.getAnimatedValue());
                }
            });
        } else if (this.mSpringRecoverAnimator.isRunning()) {
            this.mSpringRecoverAnimator.cancel();
        }
        this.mSpringRecoverAnimator.setIntValues(new int[]{this.mOffsetSpring, 0});
        this.mSpringRecoverAnimator.start();
    }

    private static boolean checkFlag(int flags, int check) {
        return (flags & check) == check;
    }

    public boolean onMeasureChild(CoordinatorLayout parent, AppBarLayout child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
        boolean b = super.onMeasureChild(parent, child, parentWidthMeasureSpec, widthUsed, parentHeightMeasureSpec, heightUsed);
        if (this.mPreHeadHeight == 0 && child.getHeight() != 0) {
            this.mPreHeadHeight = this.getHeaderExpandedHeight(child);
        }
        return b;
    }

    int getHeaderExpandedHeight(AppBarLayout appBarLayout) {
        int range = 0;
        int z = appBarLayout.getChildCount();
        for (int i = 0; i < z; ++i) {
            View child = appBarLayout.getChildAt(i);
            AppBarLayout.LayoutParams lp = (AppBarLayout.LayoutParams)child.getLayoutParams();
            int childHeight = child.getMeasuredHeight();
            range += (childHeight += lp.topMargin + lp.bottomMargin);
        }
        return Math.max(0, range);
    }

    void onFlingFinished(CoordinatorLayout parent, AppBarLayout layout) {
        this.snapToChildIfNeeded(parent, layout);
        this.animateRecoverBySpring(parent, layout);
    }

    private void snapToChildIfNeeded(CoordinatorLayout coordinatorLayout, AppBarLayout abl) {
        View offsetChild;
        AppBarLayout.LayoutParams lp;
        int flags;
        int offset = this.getTopBottomOffsetForScrollingSibling();
        int offsetChildIndex = this.getChildIndexOnOffset(abl, offset);
        if (offsetChildIndex >= 0 && ((flags = (lp = (AppBarLayout.LayoutParams)(offsetChild = abl.getChildAt(offsetChildIndex)).getLayoutParams()).getScrollFlags()) & 0x11) == 17) {
            int snapTop = -offsetChild.getTop();
            int snapBottom = -offsetChild.getBottom();
            if (offsetChildIndex == abl.getChildCount() - 1) {
                snapBottom += abl.getTopInset();
            }
            if (AppBarLayoutSpringBehavior.checkFlag(flags, 2)) {
                snapBottom += ViewCompat.getMinimumHeight((View)offsetChild);
            } else if (AppBarLayoutSpringBehavior.checkFlag(flags, 5)) {
                int seam = snapBottom + ViewCompat.getMinimumHeight((View)offsetChild);
                if (offset < seam) {
                    snapTop = seam;
                } else {
                    snapBottom = seam;
                }
            }
            int newOffset = offset < (snapBottom + snapTop) / 2 ? snapBottom : snapTop;
            this.animateOffsetTo(coordinatorLayout, abl, MathUtils.constrain((int)newOffset, (int)(-abl.getTotalScrollRange()), (int)0), 0.0f);
        }
    }

    private void animateOffsetTo(CoordinatorLayout coordinatorLayout, AppBarLayout child, int offset, float velocity) {
        int duration;
        int distance = Math.abs(this.getTopBottomOffsetForScrollingSibling() - offset);
        if ((velocity = Math.abs(velocity)) > 0.0f) {
            duration = 3 * Math.round(1000.0f * ((float)distance / velocity));
        } else {
            float distanceRatio = (float)distance / (float)child.getHeight();
            duration = (int)((distanceRatio + 1.0f) * 150.0f);
        }
        this.animateOffsetWithDuration(coordinatorLayout, child, offset, duration);
    }

    private void animateOffsetWithDuration(final CoordinatorLayout coordinatorLayout, final AppBarLayout child, int offset, int duration) {
        int currentOffset = this.getTopBottomOffsetForScrollingSibling();
        if (currentOffset == offset) {
            if (this.mOffsetAnimator != null && this.mOffsetAnimator.isRunning()) {
                this.mOffsetAnimator.cancel();
            }
            return;
        }
        if (this.mOffsetAnimator == null) {
            this.mOffsetAnimator = ViewUtils.createAnimator();
            this.mOffsetAnimator.setInterpolator(AnimationUtils.DECELERATE_INTERPOLATOR);
            this.mOffsetAnimator.addUpdateListener(new ValueAnimatorCompat.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimatorCompat animator) {
                    AppBarLayoutSpringBehavior.this.setHeaderTopBottomOffset(coordinatorLayout, (View)child, animator.getAnimatedIntValue());
                }
            });
        } else {
            this.mOffsetAnimator.cancel();
        }
        this.mOffsetAnimator.setDuration((long)Math.min(duration, 600));
        this.mOffsetAnimator.setIntValues(currentOffset, offset);
        this.mOffsetAnimator.start();
    }

    private int getChildIndexOnOffset(AppBarLayout abl, int offset) {
        int count = abl.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = abl.getChildAt(i);
            if (child.getTop() > -offset || child.getBottom() < -offset) continue;
            return i;
        }
        return -1;
    }

    int setHeaderTopBottomOffset(CoordinatorLayout coordinatorLayout, AppBarLayout appBarLayout, int newOffset, int minOffset, int maxOffset) {
        int originNew = newOffset;
        int curOffset = this.getTopBottomOffsetForScrollingSibling();
        int consumed = 0;
        if (this.mOffsetSpring != 0 && newOffset < 0) {
            int newSpringOffset = this.mOffsetSpring + originNew;
            if (newSpringOffset < 0) {
                newOffset = newSpringOffset;
                newSpringOffset = 0;
            }
            this.updateSpringOffsetByscroll(coordinatorLayout, appBarLayout, newSpringOffset);
            consumed = this.getTopBottomOffsetForScrollingSibling() - originNew;
            if (newSpringOffset >= 0) {
                return consumed;
            }
        }
        if (this.mOffsetSpring > 0 && appBarLayout.getHeight() >= this.mPreHeadHeight && newOffset > 0) {
            this.updateSpringOffsetByscroll(coordinatorLayout, appBarLayout, this.mOffsetSpring + originNew / 3);
            consumed = this.getTopBottomOffsetForScrollingSibling() - originNew;
            return consumed;
        }
        if (minOffset != 0 && curOffset >= minOffset && curOffset <= maxOffset) {
            if (curOffset != (newOffset = MathUtils.constrain((int)newOffset, (int)minOffset, (int)maxOffset))) {
                int interpolatedOffset = appBarLayout.hasChildWithInterpolator() ? this.interpolateOffset(appBarLayout, newOffset) : newOffset;
                boolean offsetChanged = this.setTopAndBottomOffset(interpolatedOffset);
                consumed = curOffset - newOffset;
                this.mOffsetDelta = newOffset - interpolatedOffset;
                if (!offsetChanged && appBarLayout.hasChildWithInterpolator()) {
                    coordinatorLayout.dispatchDependentViewsChanged((View)appBarLayout);
                }
                appBarLayout.dispatchOffsetUpdates(this.getTopAndBottomOffset());
                this.updateAppBarLayoutDrawableState(coordinatorLayout, appBarLayout, newOffset, newOffset < curOffset ? -1 : 1);
            } else if (curOffset != minOffset) {
                this.updateSpringOffsetByscroll(coordinatorLayout, appBarLayout, this.mOffsetSpring + originNew / 3);
                consumed = this.getTopBottomOffsetForScrollingSibling() - originNew;
            }
        } else {
            this.mOffsetDelta = 0;
        }
        return consumed;
    }

    private int interpolateOffset(AppBarLayout layout, int offset) {
        int absOffset = Math.abs(offset);
        int z = layout.getChildCount();
        for (int i = 0; i < z; ++i) {
            View child = layout.getChildAt(i);
            AppBarLayout.LayoutParams childLp = (AppBarLayout.LayoutParams)child.getLayoutParams();
            Interpolator interpolator = childLp.getScrollInterpolator();
            if (absOffset < child.getTop() || absOffset > child.getBottom()) continue;
            if (interpolator == null) break;
            int childScrollableHeight = 0;
            int flags = childLp.getScrollFlags();
            if ((flags & 1) != 0) {
                childScrollableHeight += child.getHeight() + childLp.topMargin + childLp.bottomMargin;
                if ((flags & 2) != 0) {
                    childScrollableHeight -= ViewCompat.getMinimumHeight((View)child);
                }
            }
            if (ViewCompat.getFitsSystemWindows((View)child)) {
                childScrollableHeight -= layout.getTopInset();
            }
            if (childScrollableHeight <= 0) break;
            int offsetForView = absOffset - child.getTop();
            int interpolatedDiff = Math.round((float)childScrollableHeight * interpolator.getInterpolation((float)offsetForView / (float)childScrollableHeight));
            return Integer.signum(offset) * (child.getTop() + interpolatedDiff);
        }
        return offset;
    }

    private void updateAppBarLayoutDrawableState(CoordinatorLayout parent, AppBarLayout layout, int offset, int direction) {
        View child = AppBarLayoutSpringBehavior.getAppBarChildOnOffset(layout, offset);
        if (child != null) {
            boolean changed;
            AppBarLayout.LayoutParams childLp = (AppBarLayout.LayoutParams)child.getLayoutParams();
            int flags = childLp.getScrollFlags();
            boolean collapsed = false;
            if ((flags & 1) != 0) {
                int minHeight = ViewCompat.getMinimumHeight((View)child);
                if (direction > 0 && (flags & 0xC) != 0) {
                    collapsed = -offset >= child.getBottom() - minHeight - layout.getTopInset();
                } else if ((flags & 2) != 0) {
                    boolean bl = collapsed = -offset >= child.getBottom() - minHeight - layout.getTopInset();
                }
            }
            if ((changed = layout.setCollapsedState(collapsed)) && Build.VERSION.SDK_INT >= 11 && this.shouldJumpElevationState(parent, layout)) {
                layout.jumpDrawablesToCurrentState();
            }
        }
    }

    private boolean shouldJumpElevationState(CoordinatorLayout parent, AppBarLayout layout) {
        List dependencies = parent.getDependents((View)layout);
        int size = dependencies.size();
        for (int i = 0; i < size; ++i) {
            View dependency = (View)dependencies.get(i);
            CoordinatorLayout.LayoutParams lp = (CoordinatorLayout.LayoutParams)dependency.getLayoutParams();
            CoordinatorLayout.Behavior behavior = lp.getBehavior();
            if (!(behavior instanceof AppBarLayout.ScrollingViewBehavior)) continue;
            return ((AppBarLayout.ScrollingViewBehavior)behavior).getOverlayTop() != 0;
        }
        return false;
    }

    private static View getAppBarChildOnOffset(AppBarLayout layout, int offset) {
        int absOffset = Math.abs(offset);
        int z = layout.getChildCount();
        for (int i = 0; i < z; ++i) {
            View child = layout.getChildAt(i);
            if (absOffset < child.getTop() || absOffset > child.getBottom()) continue;
            return child;
        }
        return null;
    }

    private void updateSpringOffsetByscroll(CoordinatorLayout coordinatorLayout, AppBarLayout appBarLayout, int offset) {
        if (this.mSpringRecoverAnimator != null && this.mSpringRecoverAnimator.isRunning()) {
            this.mSpringRecoverAnimator.cancel();
        }
        this.updateSpringHeaderHeight(coordinatorLayout, appBarLayout, offset);
    }

    private void updateSpringHeaderHeight(CoordinatorLayout coordinatorLayout, AppBarLayout appBarLayout, int offset) {
        if (appBarLayout.getHeight() < this.mPreHeadHeight || offset < 0) {
            return;
        }
        this.mOffsetSpring = offset;
        if (this.mSpringOffsetCallback != null) {
            this.mSpringOffsetCallback.springCallback(this.mOffsetSpring);
        }
        CoordinatorLayout.LayoutParams layoutParams = (CoordinatorLayout.LayoutParams)appBarLayout.getLayoutParams();
        layoutParams.height = this.mPreHeadHeight + offset;
        appBarLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        coordinatorLayout.dispatchDependentViewsChanged((View)appBarLayout);
    }

    public int getOffsetSpring() {
        return this.mOffsetSpring;
    }

    public SpringOffsetCallback getSpringOffsetCallback() {
        return this.mSpringOffsetCallback;
    }

    public void setSpringOffsetCallback(SpringOffsetCallback springOffsetCallback) {
        this.mSpringOffsetCallback = springOffsetCallback;
    }

    @VisibleForTesting
    boolean isOffsetAnimatorRunning() {
        return this.mOffsetAnimator != null && this.mOffsetAnimator.isRunning();
    }

    public static interface SpringOffsetCallback {
        public void springCallback(int var1);
    }
}

