/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.com.google.common.collect;

import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Preconditions;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.CollectPreconditions;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Hashing;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableCollection;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableList;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableMap;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableSet;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.UnmodifiableIterator;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;

final class RegularImmutableMap<K, V>
extends ImmutableMap<K, V> {
    static final ImmutableMap<Object, Object> EMPTY = new RegularImmutableMap<Object, Object>(null, new Object[0], 0);
    private final transient int[] hashTable;
    final transient Object[] alternatingKeysAndValues;
    private final transient int size;

    static <K, V> RegularImmutableMap<K, V> create(int n, Object[] objectArray) {
        if (n == 0) {
            return (RegularImmutableMap)EMPTY;
        }
        if (n == 1) {
            CollectPreconditions.checkEntryNotNull(objectArray[0], objectArray[1]);
            return new RegularImmutableMap<K, V>(null, objectArray, 1);
        }
        Preconditions.checkPositionIndex(n, objectArray.length >> 1);
        int n2 = ImmutableSet.chooseTableSize(n);
        int[] nArray = RegularImmutableMap.createHashTable(objectArray, n, n2, 0);
        return new RegularImmutableMap<K, V>(nArray, objectArray, n);
    }

    static int[] createHashTable(Object[] objectArray, int n, int n2, int n3) {
        if (n == 1) {
            CollectPreconditions.checkEntryNotNull(objectArray[n3], objectArray[n3 ^ 1]);
            return null;
        }
        int n4 = n2 - 1;
        int[] nArray = new int[n2];
        Arrays.fill(nArray, -1);
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[2 * i + n3];
            Object object2 = objectArray[2 * i + (n3 ^ 1)];
            CollectPreconditions.checkEntryNotNull(object, object2);
            int n5 = Hashing.smear(object.hashCode());
            while (true) {
                int n6;
                if ((n6 = nArray[n5 &= n4]) == -1) break;
                if (objectArray[n6].equals(object)) {
                    throw new IllegalArgumentException("Multiple entries with same key: " + object + "=" + object2 + " and " + objectArray[n6] + "=" + objectArray[n6 ^ 1]);
                }
                ++n5;
            }
            nArray[n5] = 2 * i + n3;
        }
        return nArray;
    }

    private RegularImmutableMap(int[] nArray, Object[] objectArray, int n) {
        this.hashTable = nArray;
        this.alternatingKeysAndValues = objectArray;
        this.size = n;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public V get(Object object) {
        return (V)RegularImmutableMap.get(this.hashTable, this.alternatingKeysAndValues, this.size, 0, object);
    }

    static Object get(int[] nArray, Object[] objectArray, int n, int n2, Object object) {
        if (object == null) {
            return null;
        }
        if (n == 1) {
            return objectArray[n2].equals(object) ? objectArray[n2 ^ 1] : null;
        }
        if (nArray == null) {
            return null;
        }
        int n3 = nArray.length - 1;
        int n4 = Hashing.smear(object.hashCode());
        int n5;
        while ((n5 = nArray[n4 &= n3]) != -1) {
            if (objectArray[n5].equals(object)) {
                return objectArray[n5 ^ 1];
            }
            ++n4;
        }
        return null;
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return new EntrySet(this, this.alternatingKeysAndValues, 0, this.size);
    }

    @Override
    ImmutableSet<K> createKeySet() {
        KeysOrValuesAsList keysOrValuesAsList = new KeysOrValuesAsList(this.alternatingKeysAndValues, 0, this.size);
        return new KeySet<Object>(this, keysOrValuesAsList);
    }

    @Override
    ImmutableCollection<V> createValues() {
        return new KeysOrValuesAsList(this.alternatingKeysAndValues, 1, this.size);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    static final class KeySet<K>
    extends ImmutableSet<K> {
        private final transient ImmutableMap<K, ?> map;
        private final transient ImmutableList<K> list;

        KeySet(ImmutableMap<K, ?> immutableMap, ImmutableList<K> immutableList) {
            this.map = immutableMap;
            this.list = immutableList;
        }

        @Override
        public UnmodifiableIterator<K> iterator() {
            return this.asList().iterator();
        }

        @Override
        int copyIntoArray(Object[] objectArray, int n) {
            return this.asList().copyIntoArray(objectArray, n);
        }

        @Override
        public ImmutableList<K> asList() {
            return this.list;
        }

        @Override
        public boolean contains(Object object) {
            return this.map.get(object) != null;
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    static final class KeysOrValuesAsList
    extends ImmutableList<Object> {
        private final transient Object[] alternatingKeysAndValues;
        private final transient int offset;
        private final transient int size;

        KeysOrValuesAsList(Object[] objectArray, int n, int n2) {
            this.alternatingKeysAndValues = objectArray;
            this.offset = n;
            this.size = n2;
        }

        @Override
        public Object get(int n) {
            Preconditions.checkElementIndex(n, this.size);
            return this.alternatingKeysAndValues[2 * n + this.offset];
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    static class EntrySet<K, V>
    extends ImmutableSet<Map.Entry<K, V>> {
        private final transient ImmutableMap<K, V> map;
        private final transient Object[] alternatingKeysAndValues;
        private final transient int keyOffset;
        private final transient int size;

        EntrySet(ImmutableMap<K, V> immutableMap, Object[] objectArray, int n, int n2) {
            this.map = immutableMap;
            this.alternatingKeysAndValues = objectArray;
            this.keyOffset = n;
            this.size = n2;
        }

        @Override
        public UnmodifiableIterator<Map.Entry<K, V>> iterator() {
            return this.asList().iterator();
        }

        @Override
        int copyIntoArray(Object[] objectArray, int n) {
            return this.asList().copyIntoArray(objectArray, n);
        }

        @Override
        ImmutableList<Map.Entry<K, V>> createAsList() {
            return new ImmutableList<Map.Entry<K, V>>(){

                @Override
                public Map.Entry<K, V> get(int n) {
                    Preconditions.checkElementIndex(n, EntrySet.this.size);
                    Object object = EntrySet.this.alternatingKeysAndValues[2 * n + EntrySet.this.keyOffset];
                    Object object2 = EntrySet.this.alternatingKeysAndValues[2 * n + (EntrySet.this.keyOffset ^ 1)];
                    return new AbstractMap.SimpleImmutableEntry<Object, Object>(object, object2);
                }

                @Override
                public int size() {
                    return EntrySet.this.size;
                }

                @Override
                public boolean isPartialView() {
                    return true;
                }
            };
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                Object k = entry.getKey();
                Object v = entry.getValue();
                return v != null && v.equals(this.map.get(k));
            }
            return false;
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        public int size() {
            return this.size;
        }
    }
}

