/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.com.google.common.collect;

import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Function;
import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Objects;
import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Preconditions;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.AbstractMapEntry;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.CollectPreconditions;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Collections2;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableEntry;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableMap;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Iterators;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Sets;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.TransformedIterator;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class Maps {
    private Maps() {
    }

    static <K> Function<Map.Entry<K, ?>, K> keyFunction() {
        return EntryFunction.KEY;
    }

    static <V> Function<Map.Entry<?, V>, V> valueFunction() {
        return EntryFunction.VALUE;
    }

    static <K, V> Iterator<V> valueIterator(Iterator<Map.Entry<K, V>> iterator) {
        return new TransformedIterator<Map.Entry<K, V>, V>(iterator){

            @Override
            V transform(Map.Entry<K, V> entry) {
                return entry.getValue();
            }
        };
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    static int capacity(int n) {
        if (n < 3) {
            CollectPreconditions.checkNonnegative(n, "expectedSize");
            return n + 1;
        }
        if (n < 0x40000000) {
            return (int)((float)n / 0.75f + 1.0f);
        }
        return Integer.MAX_VALUE;
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    public static <K, V> ImmutableMap<K, V> toMap(Iterable<K> iterable, Function<? super K, V> function) {
        return Maps.toMap(iterable.iterator(), function);
    }

    public static <K, V> ImmutableMap<K, V> toMap(Iterator<K> iterator, Function<? super K, V> function) {
        Preconditions.checkNotNull(function);
        LinkedHashMap<K, V> linkedHashMap = Maps.newLinkedHashMap();
        while (iterator.hasNext()) {
            K k = iterator.next();
            linkedHashMap.put(k, function.apply(k));
        }
        return ImmutableMap.copyOf(linkedHashMap);
    }

    public static <K, V> Map.Entry<K, V> immutableEntry(K k, V v) {
        return new ImmutableEntry<K, V>(k, v);
    }

    public static <K, V1, V2> Map<K, V2> transformValues(Map<K, V1> map, Function<? super V1, V2> function) {
        return Maps.transformEntries(map, Maps.asEntryTransformer(function));
    }

    public static <K, V1, V2> Map<K, V2> transformEntries(Map<K, V1> map, EntryTransformer<? super K, ? super V1, V2> entryTransformer) {
        return new TransformedEntriesMap<K, V1, V2>(map, entryTransformer);
    }

    static <K, V1, V2> EntryTransformer<K, V1, V2> asEntryTransformer(final Function<? super V1, V2> function) {
        Preconditions.checkNotNull(function);
        return new EntryTransformer<K, V1, V2>(){

            @Override
            public V2 transformEntry(K k, V1 V1) {
                return function.apply(V1);
            }
        };
    }

    static <V2, K, V1> Map.Entry<K, V2> transformEntry(final EntryTransformer<? super K, ? super V1, V2> entryTransformer, final Map.Entry<K, V1> entry) {
        Preconditions.checkNotNull(entryTransformer);
        Preconditions.checkNotNull(entry);
        return new AbstractMapEntry<K, V2>(){

            @Override
            public K getKey() {
                return entry.getKey();
            }

            @Override
            public V2 getValue() {
                return entryTransformer.transformEntry(entry.getKey(), entry.getValue());
            }
        };
    }

    static <K, V1, V2> Function<Map.Entry<K, V1>, Map.Entry<K, V2>> asEntryToEntryFunction(final EntryTransformer<? super K, ? super V1, V2> entryTransformer) {
        Preconditions.checkNotNull(entryTransformer);
        return new Function<Map.Entry<K, V1>, Map.Entry<K, V2>>(){

            @Override
            public Map.Entry<K, V2> apply(Map.Entry<K, V1> entry) {
                return Maps.transformEntry(entryTransformer, entry);
            }
        };
    }

    static <V> V safeGet(Map<?, V> map, Object object) {
        Preconditions.checkNotNull(map);
        try {
            return map.get(object);
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            return null;
        }
    }

    static boolean equalsImpl(Map<?, ?> map, Object object) {
        if (map == object) {
            return true;
        }
        if (object instanceof Map) {
            Map map2 = (Map)object;
            return map.entrySet().equals(map2.entrySet());
        }
        return false;
    }

    static String toStringImpl(Map<?, ?> map) {
        StringBuilder stringBuilder = Collections2.newStringBuilderForCollection(map.size()).append('{');
        boolean bl = true;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            bl = false;
            stringBuilder.append(entry.getKey()).append('=').append(entry.getValue());
        }
        return stringBuilder.append('}').toString();
    }

    static <K> K keyOrNull(Map.Entry<K, ?> entry) {
        return entry == null ? null : (K)entry.getKey();
    }

    static abstract class EntrySet<K, V>
    extends Sets.ImprovedAbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        abstract Map<K, V> map();

        @Override
        public int size() {
            return this.map().size();
        }

        @Override
        public void clear() {
            this.map().clear();
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                Object k = entry.getKey();
                V v = Maps.safeGet(this.map(), k);
                return Objects.equal(v, entry.getValue()) && (v != null || this.map().containsKey(k));
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            return this.map().isEmpty();
        }

        @Override
        public boolean remove(Object object) {
            if (this.contains(object)) {
                Map.Entry entry = (Map.Entry)object;
                return this.map().keySet().remove(entry.getKey());
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            try {
                return super.removeAll(Preconditions.checkNotNull(collection));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                return Sets.removeAllImpl(this, collection.iterator());
            }
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            try {
                return super.retainAll(Preconditions.checkNotNull(collection));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                HashSet hashSet = Sets.newHashSetWithExpectedSize(collection.size());
                for (Object obj : collection) {
                    if (!this.contains(obj)) continue;
                    Map.Entry entry = (Map.Entry)obj;
                    hashSet.add(entry.getKey());
                }
                return this.map().keySet().retainAll(hashSet);
            }
        }
    }

    static class Values<K, V>
    extends AbstractCollection<V> {
        final Map<K, V> map;

        Values(Map<K, V> map) {
            this.map = Preconditions.checkNotNull(map);
        }

        final Map<K, V> map() {
            return this.map;
        }

        @Override
        public Iterator<V> iterator() {
            return Maps.valueIterator(this.map().entrySet().iterator());
        }

        @Override
        public boolean remove(Object object) {
            try {
                return super.remove(object);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                for (Map.Entry<K, V> entry : this.map().entrySet()) {
                    if (!Objects.equal(object, entry.getValue())) continue;
                    this.map().remove(entry.getKey());
                    return true;
                }
                return false;
            }
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            try {
                return super.removeAll(Preconditions.checkNotNull(collection));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                HashSet<K> hashSet = Sets.newHashSet();
                for (Map.Entry<K, V> entry : this.map().entrySet()) {
                    if (!collection.contains(entry.getValue())) continue;
                    hashSet.add(entry.getKey());
                }
                return this.map().keySet().removeAll(hashSet);
            }
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            try {
                return super.retainAll(Preconditions.checkNotNull(collection));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                HashSet<K> hashSet = Sets.newHashSet();
                for (Map.Entry<K, V> entry : this.map().entrySet()) {
                    if (!collection.contains(entry.getValue())) continue;
                    hashSet.add(entry.getKey());
                }
                return this.map().keySet().retainAll(hashSet);
            }
        }

        @Override
        public int size() {
            return this.map().size();
        }

        @Override
        public boolean isEmpty() {
            return this.map().isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return this.map().containsValue(object);
        }

        @Override
        public void clear() {
            this.map().clear();
        }
    }

    static abstract class IteratorBasedAbstractMap<K, V>
    extends AbstractMap<K, V> {
        IteratorBasedAbstractMap() {
        }

        abstract Iterator<Map.Entry<K, V>> entryIterator();

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new EntrySet<K, V>(){

                @Override
                Map<K, V> map() {
                    return IteratorBasedAbstractMap.this;
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return IteratorBasedAbstractMap.this.entryIterator();
                }
            };
        }

        @Override
        public void clear() {
            Iterators.clear(this.entryIterator());
        }
    }

    static class TransformedEntriesMap<K, V1, V2>
    extends IteratorBasedAbstractMap<K, V2> {
        final Map<K, V1> fromMap;
        final EntryTransformer<? super K, ? super V1, V2> transformer;

        TransformedEntriesMap(Map<K, V1> map, EntryTransformer<? super K, ? super V1, V2> entryTransformer) {
            this.fromMap = Preconditions.checkNotNull(map);
            this.transformer = Preconditions.checkNotNull(entryTransformer);
        }

        @Override
        public int size() {
            return this.fromMap.size();
        }

        @Override
        public boolean containsKey(Object object) {
            return this.fromMap.containsKey(object);
        }

        @Override
        public V2 get(Object object) {
            V1 V1 = this.fromMap.get(object);
            return (V2)(V1 != null || this.fromMap.containsKey(object) ? this.transformer.transformEntry(object, V1) : null);
        }

        @Override
        public V2 remove(Object object) {
            return this.fromMap.containsKey(object) ? (V2)this.transformer.transformEntry((K)object, (V1)this.fromMap.remove(object)) : null;
        }

        @Override
        public void clear() {
            this.fromMap.clear();
        }

        @Override
        public Set<K> keySet() {
            return this.fromMap.keySet();
        }

        @Override
        Iterator<Map.Entry<K, V2>> entryIterator() {
            return Iterators.transform(this.fromMap.entrySet().iterator(), Maps.asEntryToEntryFunction(this.transformer));
        }

        @Override
        public Collection<V2> values() {
            return new Values(this);
        }
    }

    public static interface EntryTransformer<K, V1, V2> {
        public V2 transformEntry(K var1, V1 var2);
    }

    private static abstract class EntryFunction
    extends Enum<EntryFunction>
    implements Function<Map.Entry<?, ?>, Object> {
        public static final /* enum */ EntryFunction KEY = new EntryFunction(){

            @Override
            public Object apply(Map.Entry<?, ?> entry) {
                return entry.getKey();
            }
        };
        public static final /* enum */ EntryFunction VALUE = new EntryFunction(){

            @Override
            public Object apply(Map.Entry<?, ?> entry) {
                return entry.getValue();
            }
        };
        private static final /* synthetic */ EntryFunction[] $VALUES;

        static {
            $VALUES = new EntryFunction[]{KEY, VALUE};
        }
    }
}

