/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.util;

import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Lists;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.base.BaseTryBlock;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.ExceptionHandler;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.TryBlock;
import com.github.tmurakami.dexopener.repackaged.org.jf.util.ExceptionWithContext;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class TryListBuilder<EH extends ExceptionHandler> {
    private final MutableTryBlock<EH> listStart = new MutableTryBlock(0, 0);
    private final MutableTryBlock<EH> listEnd = new MutableTryBlock(0, 0);

    public TryListBuilder() {
        this.listStart.next = this.listEnd;
        this.listEnd.prev = this.listStart;
    }

    public static <EH extends ExceptionHandler> List<TryBlock<EH>> massageTryBlocks(List<? extends TryBlock<? extends EH>> list) {
        TryListBuilder<ExceptionHandler> tryListBuilder = new TryListBuilder<ExceptionHandler>();
        for (TryBlock<EH> tryBlock : list) {
            int n = tryBlock.getStartCodeAddress();
            int n2 = n + tryBlock.getCodeUnitCount();
            for (ExceptionHandler exceptionHandler : tryBlock.getExceptionHandlers()) {
                tryListBuilder.addHandler(n, n2, exceptionHandler);
            }
        }
        return tryListBuilder.getTryBlocks();
    }

    private TryBounds<EH> getBoundingRanges(int n, int n2) {
        int n3;
        int n4;
        MutableTryBlock mutableTryBlock = null;
        MutableTryBlock mutableTryBlock2 = this.listStart.next;
        while (mutableTryBlock2 != this.listEnd) {
            n4 = mutableTryBlock2.startCodeAddress;
            n3 = mutableTryBlock2.endCodeAddress;
            if (n == n4) {
                mutableTryBlock = mutableTryBlock2;
                break;
            }
            if (n > n4 && n < n3) {
                mutableTryBlock = mutableTryBlock2.split(n);
                break;
            }
            if (n < n4) {
                if (n2 <= n4) {
                    mutableTryBlock = new MutableTryBlock(n, n2);
                    mutableTryBlock2.prepend(mutableTryBlock);
                    return new TryBounds(mutableTryBlock, mutableTryBlock);
                }
                mutableTryBlock = new MutableTryBlock(n, n4);
                mutableTryBlock2.prepend(mutableTryBlock);
                break;
            }
            mutableTryBlock2 = mutableTryBlock2.next;
        }
        if (mutableTryBlock == null) {
            mutableTryBlock = new MutableTryBlock(n, n2);
            this.listEnd.prepend(mutableTryBlock);
            return new TryBounds(mutableTryBlock, mutableTryBlock);
        }
        mutableTryBlock2 = mutableTryBlock;
        while (mutableTryBlock2 != this.listEnd) {
            n4 = mutableTryBlock2.startCodeAddress;
            n3 = mutableTryBlock2.endCodeAddress;
            if (n2 == n3) {
                return new TryBounds(mutableTryBlock, mutableTryBlock2);
            }
            if (n2 > n4 && n2 < n3) {
                mutableTryBlock2.split(n2);
                return new TryBounds(mutableTryBlock, mutableTryBlock2);
            }
            if (n2 <= n4) {
                MutableTryBlock mutableTryBlock3 = new MutableTryBlock(mutableTryBlock2.prev.endCodeAddress, n2);
                mutableTryBlock2.prepend(mutableTryBlock3);
                return new TryBounds(mutableTryBlock, mutableTryBlock3);
            }
            mutableTryBlock2 = mutableTryBlock2.next;
        }
        MutableTryBlock mutableTryBlock4 = new MutableTryBlock(this.listEnd.prev.endCodeAddress, n2);
        this.listEnd.prepend(mutableTryBlock4);
        return new TryBounds(mutableTryBlock, mutableTryBlock4);
    }

    public void addHandler(int n, int n2, EH EH) {
        TryBounds<EH> tryBounds = this.getBoundingRanges(n, n2);
        MutableTryBlock<EH> mutableTryBlock = tryBounds.start;
        MutableTryBlock mutableTryBlock2 = tryBounds.end;
        int n3 = n;
        MutableTryBlock<EH> mutableTryBlock3 = mutableTryBlock;
        do {
            if (mutableTryBlock3.startCodeAddress > n3) {
                MutableTryBlock mutableTryBlock4 = new MutableTryBlock(n3, mutableTryBlock3.startCodeAddress);
                mutableTryBlock3.prepend(mutableTryBlock4);
                mutableTryBlock3 = mutableTryBlock4;
            }
            mutableTryBlock3.addHandler(EH);
            n3 = mutableTryBlock3.endCodeAddress;
            mutableTryBlock3 = mutableTryBlock3.next;
        } while (mutableTryBlock3.prev != mutableTryBlock2);
    }

    public List<TryBlock<EH>> getTryBlocks() {
        return Lists.newArrayList(new Iterator<TryBlock<EH>>(){
            private MutableTryBlock<EH> next;
            {
                this.next = TryListBuilder.this.listStart;
                this.next = this.readNextItem();
            }

            protected MutableTryBlock<EH> readNextItem() {
                MutableTryBlock mutableTryBlock = this.next.next;
                if (mutableTryBlock == TryListBuilder.this.listEnd) {
                    return null;
                }
                while (mutableTryBlock.next != TryListBuilder.this.listEnd && mutableTryBlock.endCodeAddress == mutableTryBlock.next.startCodeAddress && mutableTryBlock.getExceptionHandlers().equals(mutableTryBlock.next.getExceptionHandlers())) {
                    mutableTryBlock.mergeNext();
                }
                return mutableTryBlock;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public TryBlock<EH> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                MutableTryBlock mutableTryBlock = this.next;
                this.next = this.readNextItem();
                return mutableTryBlock;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        });
    }

    private static class MutableTryBlock<EH extends ExceptionHandler>
    extends BaseTryBlock<EH> {
        public MutableTryBlock<EH> prev = null;
        public MutableTryBlock<EH> next = null;
        public int startCodeAddress;
        public int endCodeAddress;
        public List<EH> exceptionHandlers = Lists.newArrayList();

        public MutableTryBlock(int n, int n2) {
            this.startCodeAddress = n;
            this.endCodeAddress = n2;
        }

        public MutableTryBlock(int n, int n2, List<EH> list) {
            this.startCodeAddress = n;
            this.endCodeAddress = n2;
            this.exceptionHandlers = Lists.newArrayList(list);
        }

        @Override
        public int getStartCodeAddress() {
            return this.startCodeAddress;
        }

        @Override
        public int getCodeUnitCount() {
            return this.endCodeAddress - this.startCodeAddress;
        }

        @Override
        public List<EH> getExceptionHandlers() {
            return this.exceptionHandlers;
        }

        public MutableTryBlock<EH> split(int n) {
            MutableTryBlock<EH> mutableTryBlock = new MutableTryBlock<EH>(n, this.endCodeAddress, this.exceptionHandlers);
            this.endCodeAddress = n;
            this.append(mutableTryBlock);
            return mutableTryBlock;
        }

        public void delete() {
            this.next.prev = this.prev;
            this.prev.next = this.next;
        }

        public void mergeNext() {
            this.endCodeAddress = this.next.endCodeAddress;
            this.next.delete();
        }

        public void append(MutableTryBlock<EH> mutableTryBlock) {
            this.next.prev = mutableTryBlock;
            mutableTryBlock.next = this.next;
            mutableTryBlock.prev = this;
            this.next = mutableTryBlock;
        }

        public void prepend(MutableTryBlock<EH> mutableTryBlock) {
            this.prev.next = mutableTryBlock;
            mutableTryBlock.prev = this.prev;
            mutableTryBlock.next = this;
            this.prev = mutableTryBlock;
        }

        public void addHandler(EH EH) {
            for (ExceptionHandler exceptionHandler : this.exceptionHandlers) {
                String string = exceptionHandler.getExceptionType();
                String string2 = EH.getExceptionType();
                if (string == null) {
                    if (string2 != null) continue;
                    if (exceptionHandler.getHandlerCodeAddress() != EH.getHandlerCodeAddress()) {
                        throw new InvalidTryException("Multiple overlapping catch all handlers with different handlers", new Object[0]);
                    }
                    return;
                }
                if (!string.equals(string2)) continue;
                return;
            }
            this.exceptionHandlers.add(EH);
        }
    }

    public static class InvalidTryException
    extends ExceptionWithContext {
        public InvalidTryException(String string, Object ... objectArray) {
            super(string, objectArray);
        }
    }

    private static class TryBounds<EH extends ExceptionHandler> {
        public final MutableTryBlock<EH> start;
        public final MutableTryBlock<EH> end;

        public TryBounds(MutableTryBlock<EH> mutableTryBlock, MutableTryBlock<EH> mutableTryBlock2) {
            this.start = mutableTryBlock;
            this.end = mutableTryBlock2;
        }
    }
}

