/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction;

import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcode;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedDexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBuffer;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexReader;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction.DexBackedArrayPayload;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction10t;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction10x;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction11n;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction11x;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction12x;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction20bc;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction20t;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction21c;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction21ih;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction21lh;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction21s;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction21t;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction22b;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction22c;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction22cs;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction22s;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction22t;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction22x;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction23x;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction30t;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction31c;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction31i;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction31t;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction32x;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction35c;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction35mi;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction35ms;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction3rc;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction3rmi;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction3rms;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction45cc;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction4rcc;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction51l;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction.DexBackedPackedSwitchPayload;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction.DexBackedSparseSwitchPayload;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction.DexBackedUnknownInstruction;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.Instruction;
import com.github.tmurakami.dexopener.repackaged.org.jf.util.ExceptionWithContext;

public abstract class DexBackedInstruction
implements Instruction {
    public final DexBackedDexFile dexFile;
    public final Opcode opcode;
    public final int instructionStart;

    public DexBackedInstruction(DexBackedDexFile dexBackedDexFile, Opcode opcode, int n) {
        this.dexFile = dexBackedDexFile;
        this.opcode = opcode;
        this.instructionStart = n;
    }

    @Override
    public Opcode getOpcode() {
        return this.opcode;
    }

    @Override
    public int getCodeUnits() {
        return this.opcode.format.size / 2;
    }

    public static Instruction readFrom(DexBackedDexFile dexBackedDexFile, DexReader dexReader) {
        int n = dexReader.peekUbyte();
        if (n == 0) {
            n = dexReader.peekUshort();
        }
        Opcode opcode = dexBackedDexFile.getOpcodes().getOpcodeByValue(n);
        DexBackedInstruction dexBackedInstruction = DexBackedInstruction.buildInstruction(dexBackedDexFile, opcode, dexReader.getOffset() + ((DexBuffer)dexReader.dexBuf).getBaseOffset() - dexBackedDexFile.getBuffer().getBaseOffset() - dexBackedDexFile.getBaseDataOffset());
        dexReader.moveRelative(dexBackedInstruction.getCodeUnits() * 2);
        return dexBackedInstruction;
    }

    private static DexBackedInstruction buildInstruction(DexBackedDexFile dexBackedDexFile, Opcode opcode, int n) {
        if (opcode == null) {
            return new DexBackedUnknownInstruction(dexBackedDexFile, n);
        }
        switch (opcode.format) {
            case Format10t: {
                return new DexBackedInstruction10t(dexBackedDexFile, opcode, n);
            }
            case Format10x: {
                return new DexBackedInstruction10x(dexBackedDexFile, opcode, n);
            }
            case Format11n: {
                return new DexBackedInstruction11n(dexBackedDexFile, opcode, n);
            }
            case Format11x: {
                return new DexBackedInstruction11x(dexBackedDexFile, opcode, n);
            }
            case Format12x: {
                return new DexBackedInstruction12x(dexBackedDexFile, opcode, n);
            }
            case Format20bc: {
                return new DexBackedInstruction20bc(dexBackedDexFile, opcode, n);
            }
            case Format20t: {
                return new DexBackedInstruction20t(dexBackedDexFile, opcode, n);
            }
            case Format21c: {
                return new DexBackedInstruction21c(dexBackedDexFile, opcode, n);
            }
            case Format21ih: {
                return new DexBackedInstruction21ih(dexBackedDexFile, opcode, n);
            }
            case Format21lh: {
                return new DexBackedInstruction21lh(dexBackedDexFile, opcode, n);
            }
            case Format21s: {
                return new DexBackedInstruction21s(dexBackedDexFile, opcode, n);
            }
            case Format21t: {
                return new DexBackedInstruction21t(dexBackedDexFile, opcode, n);
            }
            case Format22b: {
                return new DexBackedInstruction22b(dexBackedDexFile, opcode, n);
            }
            case Format22c: {
                return new DexBackedInstruction22c(dexBackedDexFile, opcode, n);
            }
            case Format22cs: {
                return new DexBackedInstruction22cs(dexBackedDexFile, opcode, n);
            }
            case Format22s: {
                return new DexBackedInstruction22s(dexBackedDexFile, opcode, n);
            }
            case Format22t: {
                return new DexBackedInstruction22t(dexBackedDexFile, opcode, n);
            }
            case Format22x: {
                return new DexBackedInstruction22x(dexBackedDexFile, opcode, n);
            }
            case Format23x: {
                return new DexBackedInstruction23x(dexBackedDexFile, opcode, n);
            }
            case Format30t: {
                return new DexBackedInstruction30t(dexBackedDexFile, opcode, n);
            }
            case Format31c: {
                return new DexBackedInstruction31c(dexBackedDexFile, opcode, n);
            }
            case Format31i: {
                return new DexBackedInstruction31i(dexBackedDexFile, opcode, n);
            }
            case Format31t: {
                return new DexBackedInstruction31t(dexBackedDexFile, opcode, n);
            }
            case Format32x: {
                return new DexBackedInstruction32x(dexBackedDexFile, opcode, n);
            }
            case Format35c: {
                return new DexBackedInstruction35c(dexBackedDexFile, opcode, n);
            }
            case Format35ms: {
                return new DexBackedInstruction35ms(dexBackedDexFile, opcode, n);
            }
            case Format35mi: {
                return new DexBackedInstruction35mi(dexBackedDexFile, opcode, n);
            }
            case Format3rc: {
                return new DexBackedInstruction3rc(dexBackedDexFile, opcode, n);
            }
            case Format3rmi: {
                return new DexBackedInstruction3rmi(dexBackedDexFile, opcode, n);
            }
            case Format3rms: {
                return new DexBackedInstruction3rms(dexBackedDexFile, opcode, n);
            }
            case Format45cc: {
                return new DexBackedInstruction45cc(dexBackedDexFile, opcode, n);
            }
            case Format4rcc: {
                return new DexBackedInstruction4rcc(dexBackedDexFile, opcode, n);
            }
            case Format51l: {
                return new DexBackedInstruction51l(dexBackedDexFile, opcode, n);
            }
            case PackedSwitchPayload: {
                return new DexBackedPackedSwitchPayload(dexBackedDexFile, n);
            }
            case SparseSwitchPayload: {
                return new DexBackedSparseSwitchPayload(dexBackedDexFile, n);
            }
            case ArrayPayload: {
                return new DexBackedArrayPayload(dexBackedDexFile, n);
            }
        }
        throw new ExceptionWithContext("Unexpected opcode format: %s", opcode.format.toString());
    }
}

