/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked;

import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcodes;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedClassDef;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedMethod;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedMethodImplementation;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBuffer;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexReader;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.raw.HeaderItem;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.raw.MapItem;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.reference.DexBackedCallSiteReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.reference.DexBackedFieldReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.reference.DexBackedMethodHandleReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.reference.DexBackedMethodProtoReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.reference.DexBackedMethodReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.util.FixedSizeList;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.util.FixedSizeSet;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.DexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.util.DexUtil;
import java.util.AbstractList;
import java.util.List;
import java.util.Set;

public class DexBackedDexFile
implements DexFile {
    private final DexBuffer dexBuffer;
    private final DexBuffer dataBuffer;
    private final Opcodes opcodes;
    private final int stringCount;
    private final int stringStartOffset;
    private final int typeCount;
    private final int typeStartOffset;
    private final int protoCount;
    private final int protoStartOffset;
    private final int fieldCount;
    private final int fieldStartOffset;
    private final int methodCount;
    private final int methodStartOffset;
    private final int classCount;
    private final int classStartOffset;
    private final int mapOffset;
    private OptionalIndexedSection<String> stringSection = new OptionalIndexedSection<String>(){

        @Override
        public String get(int n) {
            int n2 = this.getOffset(n);
            int n3 = DexBackedDexFile.this.dexBuffer.readSmallUint(n2);
            DexReader dexReader = DexBackedDexFile.this.dataBuffer.readerAt(n3);
            int n4 = dexReader.readSmallUleb128();
            return dexReader.readString(n4);
        }

        @Override
        public int size() {
            return DexBackedDexFile.this.stringCount;
        }

        @Override
        public String getOptional(int n) {
            if (n == -1) {
                return null;
            }
            return this.get(n);
        }

        @Override
        public int getOffset(int n) {
            if (n < 0 || n >= this.size()) {
                throw new IndexOutOfBoundsException(String.format("Invalid string index %d, not in [0, %d)", n, this.size()));
            }
            return DexBackedDexFile.this.stringStartOffset + n * 4;
        }
    };
    private OptionalIndexedSection<String> typeSection = new OptionalIndexedSection<String>(){

        @Override
        public String get(int n) {
            int n2 = this.getOffset(n);
            int n3 = DexBackedDexFile.this.dexBuffer.readSmallUint(n2);
            return (String)DexBackedDexFile.this.getStringSection().get(n3);
        }

        @Override
        public int size() {
            return DexBackedDexFile.this.typeCount;
        }

        @Override
        public String getOptional(int n) {
            if (n == -1) {
                return null;
            }
            return this.get(n);
        }

        @Override
        public int getOffset(int n) {
            if (n < 0 || n >= this.size()) {
                throw new IndexOutOfBoundsException(String.format("Invalid type index %d, not in [0, %d)", n, this.size()));
            }
            return DexBackedDexFile.this.typeStartOffset + n * 4;
        }
    };
    private IndexedSection<DexBackedFieldReference> fieldSection = new IndexedSection<DexBackedFieldReference>(){

        @Override
        public DexBackedFieldReference get(int n) {
            return new DexBackedFieldReference(DexBackedDexFile.this, n);
        }

        @Override
        public int size() {
            return DexBackedDexFile.this.fieldCount;
        }

        @Override
        public int getOffset(int n) {
            if (n < 0 || n >= this.size()) {
                throw new IndexOutOfBoundsException(String.format("Invalid field index %d, not in [0, %d)", n, this.size()));
            }
            return DexBackedDexFile.this.fieldStartOffset + n * 8;
        }
    };
    private IndexedSection<DexBackedMethodReference> methodSection = new IndexedSection<DexBackedMethodReference>(){

        @Override
        public DexBackedMethodReference get(int n) {
            return new DexBackedMethodReference(DexBackedDexFile.this, n);
        }

        @Override
        public int size() {
            return DexBackedDexFile.this.methodCount;
        }

        @Override
        public int getOffset(int n) {
            if (n < 0 || n >= this.size()) {
                throw new IndexOutOfBoundsException(String.format("Invalid method index %d, not in [0, %d)", n, this.size()));
            }
            return DexBackedDexFile.this.methodStartOffset + n * 8;
        }
    };
    private IndexedSection<DexBackedMethodProtoReference> protoSection = new IndexedSection<DexBackedMethodProtoReference>(){

        @Override
        public DexBackedMethodProtoReference get(int n) {
            return new DexBackedMethodProtoReference(DexBackedDexFile.this, n);
        }

        @Override
        public int size() {
            return DexBackedDexFile.this.protoCount;
        }

        @Override
        public int getOffset(int n) {
            if (n < 0 || n >= this.size()) {
                throw new IndexOutOfBoundsException(String.format("Invalid proto index %d, not in [0, %d)", n, this.size()));
            }
            return DexBackedDexFile.this.protoStartOffset + n * 12;
        }
    };
    private IndexedSection<DexBackedClassDef> classSection = new IndexedSection<DexBackedClassDef>(){

        @Override
        public DexBackedClassDef get(int n) {
            return new DexBackedClassDef(DexBackedDexFile.this, this.getOffset(n));
        }

        @Override
        public int size() {
            return DexBackedDexFile.this.classCount;
        }

        @Override
        public int getOffset(int n) {
            if (n < 0 || n >= this.size()) {
                throw new IndexOutOfBoundsException(String.format("Invalid class index %d, not in [0, %d)", n, this.size()));
            }
            return DexBackedDexFile.this.classStartOffset + n * 32;
        }
    };
    private IndexedSection<DexBackedCallSiteReference> callSiteSection = new IndexedSection<DexBackedCallSiteReference>(){

        @Override
        public DexBackedCallSiteReference get(int n) {
            return new DexBackedCallSiteReference(DexBackedDexFile.this, n);
        }

        @Override
        public int size() {
            MapItem mapItem = DexBackedDexFile.this.getMapItemForSection(7);
            if (mapItem == null) {
                return 0;
            }
            return mapItem.getItemCount();
        }

        @Override
        public int getOffset(int n) {
            MapItem mapItem = DexBackedDexFile.this.getMapItemForSection(7);
            if (n < 0 || n >= this.size()) {
                throw new IndexOutOfBoundsException(String.format("Invalid callsite index %d, not in [0, %d)", n, this.size()));
            }
            return mapItem.getOffset() + n * 4;
        }
    };
    private IndexedSection<DexBackedMethodHandleReference> methodHandleSection = new IndexedSection<DexBackedMethodHandleReference>(){

        @Override
        public DexBackedMethodHandleReference get(int n) {
            return new DexBackedMethodHandleReference(DexBackedDexFile.this, n);
        }

        @Override
        public int size() {
            MapItem mapItem = DexBackedDexFile.this.getMapItemForSection(8);
            if (mapItem == null) {
                return 0;
            }
            return mapItem.getItemCount();
        }

        @Override
        public int getOffset(int n) {
            MapItem mapItem = DexBackedDexFile.this.getMapItemForSection(8);
            if (n < 0 || n >= this.size()) {
                throw new IndexOutOfBoundsException(String.format("Invalid method handle index %d, not in [0, %d)", n, this.size()));
            }
            return mapItem.getOffset() + n * 8;
        }
    };

    protected DexBackedDexFile(Opcodes opcodes, byte[] byArray, int n, boolean bl) {
        this.dexBuffer = new DexBuffer(byArray, n);
        this.dataBuffer = new DexBuffer(byArray, n + this.getBaseDataOffset());
        int n2 = this.getVersion(byArray, n, bl);
        this.opcodes = opcodes == null ? this.getDefaultOpcodes(n2) : opcodes;
        this.stringCount = this.dexBuffer.readSmallUint(56);
        this.stringStartOffset = this.dexBuffer.readSmallUint(60);
        this.typeCount = this.dexBuffer.readSmallUint(64);
        this.typeStartOffset = this.dexBuffer.readSmallUint(68);
        this.protoCount = this.dexBuffer.readSmallUint(72);
        this.protoStartOffset = this.dexBuffer.readSmallUint(76);
        this.fieldCount = this.dexBuffer.readSmallUint(80);
        this.fieldStartOffset = this.dexBuffer.readSmallUint(84);
        this.methodCount = this.dexBuffer.readSmallUint(88);
        this.methodStartOffset = this.dexBuffer.readSmallUint(92);
        this.classCount = this.dexBuffer.readSmallUint(96);
        this.classStartOffset = this.dexBuffer.readSmallUint(100);
        this.mapOffset = this.dexBuffer.readSmallUint(52);
    }

    public int getBaseDataOffset() {
        return 0;
    }

    protected int getVersion(byte[] byArray, int n, boolean bl) {
        if (bl) {
            return DexUtil.verifyDexHeader(byArray, n);
        }
        return HeaderItem.getVersion(byArray, n);
    }

    protected Opcodes getDefaultOpcodes(int n) {
        return Opcodes.forDexVersion(n);
    }

    public DexBuffer getBuffer() {
        return this.dexBuffer;
    }

    public DexBuffer getDataBuffer() {
        return this.dataBuffer;
    }

    public DexBackedDexFile(Opcodes opcodes, byte[] byArray) {
        this(opcodes, byArray, 0, true);
    }

    @Override
    public Opcodes getOpcodes() {
        return this.opcodes;
    }

    public Set<? extends DexBackedClassDef> getClasses() {
        return new FixedSizeSet<DexBackedClassDef>(){

            @Override
            public DexBackedClassDef readItem(int n) {
                return (DexBackedClassDef)DexBackedDexFile.this.getClassSection().get(n);
            }

            @Override
            public int size() {
                return DexBackedDexFile.this.classCount;
            }
        };
    }

    public List<MapItem> getMapItems() {
        final int n = this.dataBuffer.readSmallUint(this.mapOffset);
        return new FixedSizeList<MapItem>(){

            @Override
            public MapItem readItem(int n3) {
                int n2 = DexBackedDexFile.this.mapOffset + 4 + n3 * 12;
                return new MapItem(DexBackedDexFile.this, n2);
            }

            @Override
            public int size() {
                return n;
            }
        };
    }

    public MapItem getMapItemForSection(int n) {
        for (MapItem mapItem : this.getMapItems()) {
            if (mapItem.getType() != n) continue;
            return mapItem;
        }
        return null;
    }

    public OptionalIndexedSection<String> getStringSection() {
        return this.stringSection;
    }

    public OptionalIndexedSection<String> getTypeSection() {
        return this.typeSection;
    }

    public IndexedSection<DexBackedFieldReference> getFieldSection() {
        return this.fieldSection;
    }

    public IndexedSection<DexBackedMethodReference> getMethodSection() {
        return this.methodSection;
    }

    public IndexedSection<DexBackedMethodProtoReference> getProtoSection() {
        return this.protoSection;
    }

    public IndexedSection<DexBackedClassDef> getClassSection() {
        return this.classSection;
    }

    public IndexedSection<DexBackedCallSiteReference> getCallSiteSection() {
        return this.callSiteSection;
    }

    public IndexedSection<DexBackedMethodHandleReference> getMethodHandleSection() {
        return this.methodHandleSection;
    }

    protected DexBackedMethodImplementation createMethodImplementation(DexBackedDexFile dexBackedDexFile, DexBackedMethod dexBackedMethod, int n) {
        return new DexBackedMethodImplementation(dexBackedDexFile, dexBackedMethod, n);
    }

    public static abstract class IndexedSection<T>
    extends AbstractList<T> {
        public abstract int getOffset(int var1);
    }

    public static abstract class OptionalIndexedSection<T>
    extends IndexedSection<T> {
        public abstract T getOptional(int var1);
    }

    public static class NotADexFile
    extends RuntimeException {
        public NotADexFile() {
        }

        public NotADexFile(String string) {
            super(string);
        }
    }
}

