/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.instruction;

import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableList;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Lists;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Format;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcode;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.BuilderSwitchPayload;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.Label;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.instruction.BuilderSwitchElement;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.PackedSwitchPayload;
import java.util.List;

public class BuilderPackedSwitchPayload
extends BuilderSwitchPayload
implements PackedSwitchPayload {
    public static final Opcode OPCODE = Opcode.PACKED_SWITCH_PAYLOAD;
    protected final List<BuilderSwitchElement> switchElements;

    public BuilderPackedSwitchPayload(int n, List<? extends Label> list) {
        super(OPCODE);
        if (list == null) {
            this.switchElements = ImmutableList.of();
        } else {
            this.switchElements = Lists.newArrayList();
            int n2 = n;
            for (Label label : list) {
                this.switchElements.add(new BuilderSwitchElement(this, n2++, label));
            }
        }
    }

    public List<BuilderSwitchElement> getSwitchElements() {
        return this.switchElements;
    }

    @Override
    public int getCodeUnits() {
        return 4 + this.switchElements.size() * 2;
    }

    @Override
    public Format getFormat() {
        return BuilderPackedSwitchPayload.OPCODE.format;
    }
}

