/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder;

import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Function;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Iterables;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Lists;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Sets;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcode;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.BuilderDebugItem;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.BuilderInstruction;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.BuilderOffsetInstruction;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.BuilderSwitchPayload;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.BuilderTryBlock;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.Label;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.MethodLocation;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.SwitchLabelElement;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.debug.BuilderEndLocal;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.debug.BuilderEpilogueBegin;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.debug.BuilderLineNumber;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.debug.BuilderPrologueEnd;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.debug.BuilderRestartLocal;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.debug.BuilderSetSourceFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.debug.BuilderStartLocal;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.instruction.BuilderArrayPayload;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.instruction.BuilderInstruction10t;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.instruction.BuilderInstruction10x;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.instruction.BuilderInstruction11n;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.instruction.BuilderInstruction11x;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.instruction.BuilderInstruction12x;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.instruction.BuilderInstruction20bc;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.instruction.BuilderInstruction20t;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.instruction.BuilderInstruction21c;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.instruction.BuilderInstruction21ih;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.instruction.BuilderInstruction21lh;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.instruction.BuilderInstruction21s;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.instruction.BuilderInstruction21t;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.instruction.BuilderInstruction22b;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.instruction.BuilderInstruction22c;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.instruction.BuilderInstruction22cs;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.instruction.BuilderInstruction22s;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.instruction.BuilderInstruction22t;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.instruction.BuilderInstruction22x;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.instruction.BuilderInstruction23x;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.instruction.BuilderInstruction30t;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.instruction.BuilderInstruction31c;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.instruction.BuilderInstruction31i;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.instruction.BuilderInstruction31t;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.instruction.BuilderInstruction32x;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.instruction.BuilderInstruction35c;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.instruction.BuilderInstruction35mi;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.instruction.BuilderInstruction35ms;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.instruction.BuilderInstruction3rc;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.instruction.BuilderInstruction3rmi;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.instruction.BuilderInstruction3rms;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.instruction.BuilderInstruction51l;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.instruction.BuilderPackedSwitchPayload;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.instruction.BuilderSparseSwitchPayload;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.MethodImplementation;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.TryBlock;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.debug.DebugItem;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.debug.EndLocal;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.debug.LineNumber;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.debug.RestartLocal;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.debug.SetSourceFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.debug.StartLocal;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.Instruction;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.SwitchElement;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.ArrayPayload;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction10t;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction10x;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction11n;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction11x;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction12x;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction20bc;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction20t;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction21c;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction21ih;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction21lh;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction21s;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction21t;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction22b;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction22c;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction22cs;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction22s;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction22t;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction22x;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction23x;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction30t;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction31c;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction31i;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction31t;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction32x;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction35c;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction35mi;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction35ms;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction3rc;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction3rmi;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction3rms;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction51l;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.PackedSwitchPayload;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.SparseSwitchPayload;
import com.github.tmurakami.dexopener.repackaged.org.jf.util.ExceptionWithContext;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class MutableMethodImplementation
implements MethodImplementation {
    private final int registerCount;
    final ArrayList<MethodLocation> instructionList = Lists.newArrayList(new MethodLocation(null, 0, 0));
    private final ArrayList<BuilderTryBlock> tryBlocks = Lists.newArrayList();
    private boolean fixInstructions = true;

    /*
     * WARNING - void declaration
     */
    public MutableMethodImplementation(MethodImplementation methodImplementation) {
        void arrayList;
        this.registerCount = methodImplementation.getRegisterCount();
        int n = 0;
        int n2 = 0;
        for (Instruction instruction : methodImplementation.getInstructions()) {
            this.instructionList.add(new MethodLocation(null, n += instruction.getCodeUnits(), ++n2));
        }
        Object object = new int[n + 1];
        Arrays.fill((int[])object, -1);
        boolean i = false;
        while (arrayList < this.instructionList.size()) {
            object[this.instructionList.get((int)arrayList).codeAddress] = arrayList;
            ++arrayList;
        }
        ArrayList<1> arrayList2 = Lists.newArrayList();
        n2 = 0;
        for (Instruction instruction : methodImplementation.getInstructions()) {
            final MethodLocation methodLocation = this.instructionList.get(n2);
            Opcode opcode = instruction.getOpcode();
            if (opcode == Opcode.PACKED_SWITCH_PAYLOAD || opcode == Opcode.SPARSE_SWITCH_PAYLOAD) {
                arrayList2.add(new Task((int[])object, instruction){
                    final /* synthetic */ int[] val$codeAddressToIndex;
                    final /* synthetic */ Instruction val$instruction;
                    {
                        this.val$codeAddressToIndex = nArray;
                        this.val$instruction = instruction;
                    }

                    @Override
                    public void perform() {
                        MutableMethodImplementation.this.convertAndSetInstruction(methodLocation, this.val$codeAddressToIndex, this.val$instruction);
                    }
                });
            } else {
                this.convertAndSetInstruction(methodLocation, (int[])object, instruction);
            }
            ++n2;
        }
        for (Task task : arrayList2) {
            task.perform();
        }
        for (DebugItem debugItem : methodImplementation.getDebugItems()) {
            int n3 = debugItem.getCodeAddress();
            int n4 = this.mapCodeAddressToIndex((int[])object, n3);
            MethodLocation methodLocation = this.instructionList.get(n4);
            Object object2 = this.convertDebugItem(debugItem);
            methodLocation.getDebugItems().add((BuilderDebugItem)object2);
            ((BuilderDebugItem)object2).location = methodLocation;
        }
        for (TryBlock tryBlock : methodImplementation.getTryBlocks()) {
            Label label = this.newLabel((int[])object, tryBlock.getStartCodeAddress());
            Label label2 = this.newLabel((int[])object, tryBlock.getStartCodeAddress() + tryBlock.getCodeUnitCount());
            for (Object object2 : tryBlock.getExceptionHandlers()) {
                this.tryBlocks.add(new BuilderTryBlock(label, label2, object2.getExceptionTypeReference(), this.newLabel((int[])object, object2.getHandlerCodeAddress())));
            }
        }
    }

    @Override
    public int getRegisterCount() {
        return this.registerCount;
    }

    public List<BuilderInstruction> getInstructions() {
        if (this.fixInstructions) {
            this.fixInstructions();
        }
        return new AbstractList<BuilderInstruction>(){

            @Override
            public BuilderInstruction get(int n) {
                if (n >= this.size()) {
                    throw new IndexOutOfBoundsException();
                }
                if (MutableMethodImplementation.this.fixInstructions) {
                    MutableMethodImplementation.this.fixInstructions();
                }
                return MutableMethodImplementation.this.instructionList.get((int)n).instruction;
            }

            @Override
            public int size() {
                if (MutableMethodImplementation.this.fixInstructions) {
                    MutableMethodImplementation.this.fixInstructions();
                }
                return MutableMethodImplementation.this.instructionList.size() - 1;
            }
        };
    }

    public List<BuilderTryBlock> getTryBlocks() {
        if (this.fixInstructions) {
            this.fixInstructions();
        }
        return Collections.unmodifiableList(this.tryBlocks);
    }

    @Override
    public Iterable<? extends DebugItem> getDebugItems() {
        if (this.fixInstructions) {
            this.fixInstructions();
        }
        return Iterables.concat(Iterables.transform(this.instructionList, new Function<MethodLocation, Iterable<? extends DebugItem>>(){

            @Override
            public Iterable<? extends DebugItem> apply(MethodLocation methodLocation) {
                assert (methodLocation != null);
                if (MutableMethodImplementation.this.fixInstructions) {
                    throw new IllegalStateException("This iterator was invalidated by a change to this MutableMethodImplementation.");
                }
                return methodLocation.getDebugItems();
            }
        }));
    }

    public void addInstruction(int n, BuilderInstruction builderInstruction) {
        if (n >= this.instructionList.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (n == this.instructionList.size() - 1) {
            this.addInstruction(builderInstruction);
            return;
        }
        int n2 = this.instructionList.get(n).getCodeAddress();
        MethodLocation methodLocation = new MethodLocation(builderInstruction, n2, n);
        this.instructionList.add(n, methodLocation);
        builderInstruction.location = methodLocation;
        n2 += builderInstruction.getCodeUnits();
        for (int i = n + 1; i < this.instructionList.size(); ++i) {
            MethodLocation methodLocation2 = this.instructionList.get(i);
            ++methodLocation2.index;
            methodLocation2.codeAddress = n2;
            if (methodLocation2.instruction != null) {
                n2 += methodLocation2.instruction.getCodeUnits();
                continue;
            }
            assert (i == this.instructionList.size() - 1);
        }
        this.fixInstructions = true;
    }

    public void addInstruction(BuilderInstruction builderInstruction) {
        MethodLocation methodLocation = this.instructionList.get(this.instructionList.size() - 1);
        methodLocation.instruction = builderInstruction;
        builderInstruction.location = methodLocation;
        int n = methodLocation.codeAddress + builderInstruction.getCodeUnits();
        this.instructionList.add(new MethodLocation(null, n, this.instructionList.size()));
        this.fixInstructions = true;
    }

    public void replaceInstruction(int n, BuilderInstruction builderInstruction) {
        MethodLocation methodLocation;
        if (n >= this.instructionList.size() - 1) {
            throw new IndexOutOfBoundsException();
        }
        builderInstruction.location = methodLocation = this.instructionList.get(n);
        BuilderInstruction builderInstruction2 = methodLocation.instruction;
        assert (builderInstruction2 != null);
        builderInstruction2.location = null;
        methodLocation.instruction = builderInstruction;
        int n2 = methodLocation.codeAddress + methodLocation.instruction.getCodeUnits();
        for (int i = n + 1; i < this.instructionList.size(); ++i) {
            MethodLocation methodLocation2 = this.instructionList.get(i);
            methodLocation2.codeAddress = n2;
            Instruction instruction = methodLocation2.getInstruction();
            if (instruction != null) {
                n2 += instruction.getCodeUnits();
                continue;
            }
            assert (i == this.instructionList.size() - 1);
        }
        this.fixInstructions = true;
    }

    public void removeInstruction(int n) {
        if (n >= this.instructionList.size() - 1) {
            throw new IndexOutOfBoundsException();
        }
        MethodLocation methodLocation = this.instructionList.get(n);
        methodLocation.instruction = null;
        MethodLocation methodLocation2 = this.instructionList.get(n + 1);
        methodLocation.mergeInto(methodLocation2);
        this.instructionList.remove(n);
        int n2 = methodLocation.codeAddress;
        for (int i = n; i < this.instructionList.size(); ++i) {
            MethodLocation methodLocation3 = this.instructionList.get(i);
            methodLocation3.index = i;
            methodLocation3.codeAddress = n2;
            Instruction instruction = methodLocation3.getInstruction();
            if (instruction != null) {
                n2 += instruction.getCodeUnits();
                continue;
            }
            assert (i == this.instructionList.size() - 1);
        }
        this.fixInstructions = true;
    }

    private BuilderInstruction getFirstNonNop(int n) {
        for (int i = n; i < this.instructionList.size() - 1; ++i) {
            BuilderInstruction builderInstruction = this.instructionList.get((int)i).instruction;
            assert (builderInstruction != null);
            if (builderInstruction.getOpcode() == Opcode.NOP) continue;
            return builderInstruction;
        }
        return null;
    }

    private void fixInstructions() {
        boolean bl;
        Object object;
        Object object2;
        HashSet<Object> hashSet = Sets.newHashSet();
        for (MethodLocation methodLocation : this.instructionList) {
            object2 = methodLocation.instruction;
            if (object2 == null) continue;
            switch (((BuilderInstruction)object2).getOpcode()) {
                case SPARSE_SWITCH: 
                case PACKED_SWITCH: {
                    object = ((BuilderOffsetInstruction)object2).getTarget().getLocation();
                    BuilderInstruction builderInstruction = ((MethodLocation)object).instruction;
                    if (builderInstruction == null) {
                        throw new IllegalStateException(String.format("Switch instruction at address/index 0x%x/%d points to the end of the method.", methodLocation.codeAddress, methodLocation.index));
                    }
                    if (builderInstruction.getOpcode() == Opcode.NOP) {
                        builderInstruction = this.getFirstNonNop(((MethodLocation)object).index + 1);
                    }
                    if (builderInstruction == null || !(builderInstruction instanceof BuilderSwitchPayload)) {
                        throw new IllegalStateException(String.format("Switch instruction at address/index 0x%x/%d does not refer to a payload instruction.", methodLocation.codeAddress, methodLocation.index));
                    }
                    if (((BuilderInstruction)object2).opcode == Opcode.PACKED_SWITCH && builderInstruction.getOpcode() != Opcode.PACKED_SWITCH_PAYLOAD || ((BuilderInstruction)object2).opcode == Opcode.SPARSE_SWITCH && builderInstruction.getOpcode() != Opcode.SPARSE_SWITCH_PAYLOAD) {
                        throw new IllegalStateException(String.format("Switch instruction at address/index 0x%x/%d refers to the wrong type of payload instruction.", methodLocation.codeAddress, methodLocation.index));
                    }
                    if (!hashSet.add(object)) {
                        throw new IllegalStateException("Multiple switch instructions refer to the same payload. This is not currently supported. Please file a bug :)");
                    }
                    ((BuilderSwitchPayload)builderInstruction).referrer = methodLocation;
                    break;
                }
            }
        }
        do {
            bl = false;
            block11: for (int i = 0; i < this.instructionList.size(); ++i) {
                object2 = this.instructionList.get(i);
                object = ((MethodLocation)object2).instruction;
                if (object == null) continue;
                switch (((BuilderInstruction)object).getOpcode()) {
                    case GOTO: {
                        int n = ((BuilderOffsetInstruction)object).internalGetCodeOffset();
                        if (n >= -128 && n <= 127) continue block11;
                        Object object3 = n < Short.MIN_VALUE || n > Short.MAX_VALUE ? new BuilderInstruction30t(Opcode.GOTO_32, ((BuilderOffsetInstruction)object).getTarget()) : new BuilderInstruction20t(Opcode.GOTO_16, ((BuilderOffsetInstruction)object).getTarget());
                        this.replaceInstruction(((MethodLocation)object2).index, (BuilderInstruction)object3);
                        bl = true;
                        continue block11;
                    }
                    case GOTO_16: {
                        int n = ((BuilderOffsetInstruction)object).internalGetCodeOffset();
                        if (n >= Short.MIN_VALUE && n <= Short.MAX_VALUE) continue block11;
                        Object object3 = new BuilderInstruction30t(Opcode.GOTO_32, ((BuilderOffsetInstruction)object).getTarget());
                        this.replaceInstruction(((MethodLocation)object2).index, (BuilderInstruction)object3);
                        bl = true;
                        continue block11;
                    }
                    case SPARSE_SWITCH_PAYLOAD: 
                    case PACKED_SWITCH_PAYLOAD: {
                        if (((BuilderSwitchPayload)object).referrer == null) {
                            this.removeInstruction(i);
                            --i;
                            bl = true;
                            continue block11;
                        }
                    }
                    case ARRAY_PAYLOAD: {
                        if ((((MethodLocation)object2).codeAddress & 1) == 0) continue block11;
                        int n = ((MethodLocation)object2).index - 1;
                        Object object3 = this.instructionList.get(n);
                        BuilderInstruction builderInstruction = ((MethodLocation)object3).instruction;
                        assert (builderInstruction != null);
                        if (builderInstruction.getOpcode() == Opcode.NOP) {
                            this.removeInstruction(n);
                            --i;
                        } else {
                            this.addInstruction(((MethodLocation)object2).index, new BuilderInstruction10x(Opcode.NOP));
                            ++i;
                        }
                        bl = true;
                    }
                }
            }
        } while (bl);
        this.fixInstructions = false;
    }

    private int mapCodeAddressToIndex(int[] nArray, int n) {
        int n2;
        while (true) {
            if (n >= nArray.length) {
                n = nArray.length - 1;
            }
            if ((n2 = nArray[n]) >= 0) break;
            --n;
        }
        return n2;
    }

    private Label newLabel(int[] nArray, int n) {
        MethodLocation methodLocation = this.instructionList.get(this.mapCodeAddressToIndex(nArray, n));
        return methodLocation.addNewLabel();
    }

    public Label newSwitchPayloadReferenceLabel(MethodLocation methodLocation, int[] nArray, int n) {
        MethodLocation methodLocation2 = this.instructionList.get(this.mapCodeAddressToIndex(nArray, n));
        SwitchPayloadReferenceLabel switchPayloadReferenceLabel = new SwitchPayloadReferenceLabel();
        switchPayloadReferenceLabel.switchLocation = methodLocation;
        methodLocation2.getLabels().add(switchPayloadReferenceLabel);
        return switchPayloadReferenceLabel;
    }

    private void setInstruction(MethodLocation methodLocation, BuilderInstruction builderInstruction) {
        methodLocation.instruction = builderInstruction;
        builderInstruction.location = methodLocation;
    }

    private void convertAndSetInstruction(MethodLocation methodLocation, int[] nArray, Instruction instruction) {
        switch (instruction.getOpcode().format) {
            case Format10t: {
                this.setInstruction(methodLocation, this.newBuilderInstruction10t(methodLocation.codeAddress, nArray, (Instruction10t)instruction));
                return;
            }
            case Format10x: {
                this.setInstruction(methodLocation, this.newBuilderInstruction10x((Instruction10x)instruction));
                return;
            }
            case Format11n: {
                this.setInstruction(methodLocation, this.newBuilderInstruction11n((Instruction11n)instruction));
                return;
            }
            case Format11x: {
                this.setInstruction(methodLocation, this.newBuilderInstruction11x((Instruction11x)instruction));
                return;
            }
            case Format12x: {
                this.setInstruction(methodLocation, this.newBuilderInstruction12x((Instruction12x)instruction));
                return;
            }
            case Format20bc: {
                this.setInstruction(methodLocation, this.newBuilderInstruction20bc((Instruction20bc)instruction));
                return;
            }
            case Format20t: {
                this.setInstruction(methodLocation, this.newBuilderInstruction20t(methodLocation.codeAddress, nArray, (Instruction20t)instruction));
                return;
            }
            case Format21c: {
                this.setInstruction(methodLocation, this.newBuilderInstruction21c((Instruction21c)instruction));
                return;
            }
            case Format21ih: {
                this.setInstruction(methodLocation, this.newBuilderInstruction21ih((Instruction21ih)instruction));
                return;
            }
            case Format21lh: {
                this.setInstruction(methodLocation, this.newBuilderInstruction21lh((Instruction21lh)instruction));
                return;
            }
            case Format21s: {
                this.setInstruction(methodLocation, this.newBuilderInstruction21s((Instruction21s)instruction));
                return;
            }
            case Format21t: {
                this.setInstruction(methodLocation, this.newBuilderInstruction21t(methodLocation.codeAddress, nArray, (Instruction21t)instruction));
                return;
            }
            case Format22b: {
                this.setInstruction(methodLocation, this.newBuilderInstruction22b((Instruction22b)instruction));
                return;
            }
            case Format22c: {
                this.setInstruction(methodLocation, this.newBuilderInstruction22c((Instruction22c)instruction));
                return;
            }
            case Format22cs: {
                this.setInstruction(methodLocation, this.newBuilderInstruction22cs((Instruction22cs)instruction));
                return;
            }
            case Format22s: {
                this.setInstruction(methodLocation, this.newBuilderInstruction22s((Instruction22s)instruction));
                return;
            }
            case Format22t: {
                this.setInstruction(methodLocation, this.newBuilderInstruction22t(methodLocation.codeAddress, nArray, (Instruction22t)instruction));
                return;
            }
            case Format22x: {
                this.setInstruction(methodLocation, this.newBuilderInstruction22x((Instruction22x)instruction));
                return;
            }
            case Format23x: {
                this.setInstruction(methodLocation, this.newBuilderInstruction23x((Instruction23x)instruction));
                return;
            }
            case Format30t: {
                this.setInstruction(methodLocation, this.newBuilderInstruction30t(methodLocation.codeAddress, nArray, (Instruction30t)instruction));
                return;
            }
            case Format31c: {
                this.setInstruction(methodLocation, this.newBuilderInstruction31c((Instruction31c)instruction));
                return;
            }
            case Format31i: {
                this.setInstruction(methodLocation, this.newBuilderInstruction31i((Instruction31i)instruction));
                return;
            }
            case Format31t: {
                this.setInstruction(methodLocation, this.newBuilderInstruction31t(methodLocation, nArray, (Instruction31t)instruction));
                return;
            }
            case Format32x: {
                this.setInstruction(methodLocation, this.newBuilderInstruction32x((Instruction32x)instruction));
                return;
            }
            case Format35c: {
                this.setInstruction(methodLocation, this.newBuilderInstruction35c((Instruction35c)instruction));
                return;
            }
            case Format35mi: {
                this.setInstruction(methodLocation, this.newBuilderInstruction35mi((Instruction35mi)instruction));
                return;
            }
            case Format35ms: {
                this.setInstruction(methodLocation, this.newBuilderInstruction35ms((Instruction35ms)instruction));
                return;
            }
            case Format3rc: {
                this.setInstruction(methodLocation, this.newBuilderInstruction3rc((Instruction3rc)instruction));
                return;
            }
            case Format3rmi: {
                this.setInstruction(methodLocation, this.newBuilderInstruction3rmi((Instruction3rmi)instruction));
                return;
            }
            case Format3rms: {
                this.setInstruction(methodLocation, this.newBuilderInstruction3rms((Instruction3rms)instruction));
                return;
            }
            case Format51l: {
                this.setInstruction(methodLocation, this.newBuilderInstruction51l((Instruction51l)instruction));
                return;
            }
            case PackedSwitchPayload: {
                this.setInstruction(methodLocation, this.newBuilderPackedSwitchPayload(methodLocation, nArray, (PackedSwitchPayload)instruction));
                return;
            }
            case SparseSwitchPayload: {
                this.setInstruction(methodLocation, this.newBuilderSparseSwitchPayload(methodLocation, nArray, (SparseSwitchPayload)instruction));
                return;
            }
            case ArrayPayload: {
                this.setInstruction(methodLocation, this.newBuilderArrayPayload((ArrayPayload)instruction));
                return;
            }
        }
        throw new ExceptionWithContext("Instruction format %s not supported", new Object[]{instruction.getOpcode().format});
    }

    private BuilderInstruction10t newBuilderInstruction10t(int n, int[] nArray, Instruction10t instruction10t) {
        return new BuilderInstruction10t(instruction10t.getOpcode(), this.newLabel(nArray, n + instruction10t.getCodeOffset()));
    }

    private BuilderInstruction10x newBuilderInstruction10x(Instruction10x instruction10x) {
        return new BuilderInstruction10x(instruction10x.getOpcode());
    }

    private BuilderInstruction11n newBuilderInstruction11n(Instruction11n instruction11n) {
        return new BuilderInstruction11n(instruction11n.getOpcode(), instruction11n.getRegisterA(), instruction11n.getNarrowLiteral());
    }

    private BuilderInstruction11x newBuilderInstruction11x(Instruction11x instruction11x) {
        return new BuilderInstruction11x(instruction11x.getOpcode(), instruction11x.getRegisterA());
    }

    private BuilderInstruction12x newBuilderInstruction12x(Instruction12x instruction12x) {
        return new BuilderInstruction12x(instruction12x.getOpcode(), instruction12x.getRegisterA(), instruction12x.getRegisterB());
    }

    private BuilderInstruction20bc newBuilderInstruction20bc(Instruction20bc instruction20bc) {
        return new BuilderInstruction20bc(instruction20bc.getOpcode(), instruction20bc.getVerificationError(), instruction20bc.getReference());
    }

    private BuilderInstruction20t newBuilderInstruction20t(int n, int[] nArray, Instruction20t instruction20t) {
        return new BuilderInstruction20t(instruction20t.getOpcode(), this.newLabel(nArray, n + instruction20t.getCodeOffset()));
    }

    private BuilderInstruction21c newBuilderInstruction21c(Instruction21c instruction21c) {
        return new BuilderInstruction21c(instruction21c.getOpcode(), instruction21c.getRegisterA(), instruction21c.getReference());
    }

    private BuilderInstruction21ih newBuilderInstruction21ih(Instruction21ih instruction21ih) {
        return new BuilderInstruction21ih(instruction21ih.getOpcode(), instruction21ih.getRegisterA(), instruction21ih.getNarrowLiteral());
    }

    private BuilderInstruction21lh newBuilderInstruction21lh(Instruction21lh instruction21lh) {
        return new BuilderInstruction21lh(instruction21lh.getOpcode(), instruction21lh.getRegisterA(), instruction21lh.getWideLiteral());
    }

    private BuilderInstruction21s newBuilderInstruction21s(Instruction21s instruction21s) {
        return new BuilderInstruction21s(instruction21s.getOpcode(), instruction21s.getRegisterA(), instruction21s.getNarrowLiteral());
    }

    private BuilderInstruction21t newBuilderInstruction21t(int n, int[] nArray, Instruction21t instruction21t) {
        return new BuilderInstruction21t(instruction21t.getOpcode(), instruction21t.getRegisterA(), this.newLabel(nArray, n + instruction21t.getCodeOffset()));
    }

    private BuilderInstruction22b newBuilderInstruction22b(Instruction22b instruction22b) {
        return new BuilderInstruction22b(instruction22b.getOpcode(), instruction22b.getRegisterA(), instruction22b.getRegisterB(), instruction22b.getNarrowLiteral());
    }

    private BuilderInstruction22c newBuilderInstruction22c(Instruction22c instruction22c) {
        return new BuilderInstruction22c(instruction22c.getOpcode(), instruction22c.getRegisterA(), instruction22c.getRegisterB(), instruction22c.getReference());
    }

    private BuilderInstruction22cs newBuilderInstruction22cs(Instruction22cs instruction22cs) {
        return new BuilderInstruction22cs(instruction22cs.getOpcode(), instruction22cs.getRegisterA(), instruction22cs.getRegisterB(), instruction22cs.getFieldOffset());
    }

    private BuilderInstruction22s newBuilderInstruction22s(Instruction22s instruction22s) {
        return new BuilderInstruction22s(instruction22s.getOpcode(), instruction22s.getRegisterA(), instruction22s.getRegisterB(), instruction22s.getNarrowLiteral());
    }

    private BuilderInstruction22t newBuilderInstruction22t(int n, int[] nArray, Instruction22t instruction22t) {
        return new BuilderInstruction22t(instruction22t.getOpcode(), instruction22t.getRegisterA(), instruction22t.getRegisterB(), this.newLabel(nArray, n + instruction22t.getCodeOffset()));
    }

    private BuilderInstruction22x newBuilderInstruction22x(Instruction22x instruction22x) {
        return new BuilderInstruction22x(instruction22x.getOpcode(), instruction22x.getRegisterA(), instruction22x.getRegisterB());
    }

    private BuilderInstruction23x newBuilderInstruction23x(Instruction23x instruction23x) {
        return new BuilderInstruction23x(instruction23x.getOpcode(), instruction23x.getRegisterA(), instruction23x.getRegisterB(), instruction23x.getRegisterC());
    }

    private BuilderInstruction30t newBuilderInstruction30t(int n, int[] nArray, Instruction30t instruction30t) {
        return new BuilderInstruction30t(instruction30t.getOpcode(), this.newLabel(nArray, n + instruction30t.getCodeOffset()));
    }

    private BuilderInstruction31c newBuilderInstruction31c(Instruction31c instruction31c) {
        return new BuilderInstruction31c(instruction31c.getOpcode(), instruction31c.getRegisterA(), instruction31c.getReference());
    }

    private BuilderInstruction31i newBuilderInstruction31i(Instruction31i instruction31i) {
        return new BuilderInstruction31i(instruction31i.getOpcode(), instruction31i.getRegisterA(), instruction31i.getNarrowLiteral());
    }

    private BuilderInstruction31t newBuilderInstruction31t(MethodLocation methodLocation, int[] nArray, Instruction31t instruction31t) {
        int n = methodLocation.getCodeAddress();
        Label label = instruction31t.getOpcode() != Opcode.FILL_ARRAY_DATA ? this.newSwitchPayloadReferenceLabel(methodLocation, nArray, n + instruction31t.getCodeOffset()) : this.newLabel(nArray, n + instruction31t.getCodeOffset());
        return new BuilderInstruction31t(instruction31t.getOpcode(), instruction31t.getRegisterA(), label);
    }

    private BuilderInstruction32x newBuilderInstruction32x(Instruction32x instruction32x) {
        return new BuilderInstruction32x(instruction32x.getOpcode(), instruction32x.getRegisterA(), instruction32x.getRegisterB());
    }

    private BuilderInstruction35c newBuilderInstruction35c(Instruction35c instruction35c) {
        return new BuilderInstruction35c(instruction35c.getOpcode(), instruction35c.getRegisterCount(), instruction35c.getRegisterC(), instruction35c.getRegisterD(), instruction35c.getRegisterE(), instruction35c.getRegisterF(), instruction35c.getRegisterG(), instruction35c.getReference());
    }

    private BuilderInstruction35mi newBuilderInstruction35mi(Instruction35mi instruction35mi) {
        return new BuilderInstruction35mi(instruction35mi.getOpcode(), instruction35mi.getRegisterCount(), instruction35mi.getRegisterC(), instruction35mi.getRegisterD(), instruction35mi.getRegisterE(), instruction35mi.getRegisterF(), instruction35mi.getRegisterG(), instruction35mi.getInlineIndex());
    }

    private BuilderInstruction35ms newBuilderInstruction35ms(Instruction35ms instruction35ms) {
        return new BuilderInstruction35ms(instruction35ms.getOpcode(), instruction35ms.getRegisterCount(), instruction35ms.getRegisterC(), instruction35ms.getRegisterD(), instruction35ms.getRegisterE(), instruction35ms.getRegisterF(), instruction35ms.getRegisterG(), instruction35ms.getVtableIndex());
    }

    private BuilderInstruction3rc newBuilderInstruction3rc(Instruction3rc instruction3rc) {
        return new BuilderInstruction3rc(instruction3rc.getOpcode(), instruction3rc.getStartRegister(), instruction3rc.getRegisterCount(), instruction3rc.getReference());
    }

    private BuilderInstruction3rmi newBuilderInstruction3rmi(Instruction3rmi instruction3rmi) {
        return new BuilderInstruction3rmi(instruction3rmi.getOpcode(), instruction3rmi.getStartRegister(), instruction3rmi.getRegisterCount(), instruction3rmi.getInlineIndex());
    }

    private BuilderInstruction3rms newBuilderInstruction3rms(Instruction3rms instruction3rms) {
        return new BuilderInstruction3rms(instruction3rms.getOpcode(), instruction3rms.getStartRegister(), instruction3rms.getRegisterCount(), instruction3rms.getVtableIndex());
    }

    private BuilderInstruction51l newBuilderInstruction51l(Instruction51l instruction51l) {
        return new BuilderInstruction51l(instruction51l.getOpcode(), instruction51l.getRegisterA(), instruction51l.getWideLiteral());
    }

    private MethodLocation findSwitchForPayload(MethodLocation methodLocation) {
        MethodLocation methodLocation2 = methodLocation;
        MethodLocation methodLocation3 = null;
        do {
            for (Label label : methodLocation2.getLabels()) {
                if (!(label instanceof SwitchPayloadReferenceLabel)) continue;
                if (methodLocation3 != null) {
                    throw new IllegalStateException("Multiple switch instructions refer to the same payload. This is not currently supported. Please file a bug :)");
                }
                methodLocation3 = ((SwitchPayloadReferenceLabel)label).switchLocation;
            }
            if (methodLocation2.index == 0) {
                return methodLocation3;
            }
            methodLocation2 = this.instructionList.get(methodLocation2.index - 1);
        } while (methodLocation2.instruction != null && methodLocation2.instruction.getOpcode() == Opcode.NOP);
        return methodLocation3;
    }

    private BuilderPackedSwitchPayload newBuilderPackedSwitchPayload(MethodLocation methodLocation, int[] nArray, PackedSwitchPayload packedSwitchPayload) {
        List<? extends SwitchElement> list = packedSwitchPayload.getSwitchElements();
        if (list.size() == 0) {
            return new BuilderPackedSwitchPayload(0, null);
        }
        MethodLocation methodLocation2 = this.findSwitchForPayload(methodLocation);
        int n = methodLocation2 == null ? 0 : methodLocation2.codeAddress;
        ArrayList<Label> arrayList = Lists.newArrayList();
        for (SwitchElement switchElement : list) {
            arrayList.add(this.newLabel(nArray, switchElement.getOffset() + n));
        }
        return new BuilderPackedSwitchPayload(list.get(0).getKey(), arrayList);
    }

    private BuilderSparseSwitchPayload newBuilderSparseSwitchPayload(MethodLocation methodLocation, int[] nArray, SparseSwitchPayload sparseSwitchPayload) {
        List<? extends SwitchElement> list = sparseSwitchPayload.getSwitchElements();
        if (list.size() == 0) {
            return new BuilderSparseSwitchPayload(null);
        }
        MethodLocation methodLocation2 = this.findSwitchForPayload(methodLocation);
        int n = methodLocation2 == null ? 0 : methodLocation2.codeAddress;
        ArrayList<SwitchLabelElement> arrayList = Lists.newArrayList();
        for (SwitchElement switchElement : list) {
            arrayList.add(new SwitchLabelElement(switchElement.getKey(), this.newLabel(nArray, switchElement.getOffset() + n)));
        }
        return new BuilderSparseSwitchPayload(arrayList);
    }

    private BuilderArrayPayload newBuilderArrayPayload(ArrayPayload arrayPayload) {
        return new BuilderArrayPayload(arrayPayload.getElementWidth(), arrayPayload.getArrayElements());
    }

    private BuilderDebugItem convertDebugItem(DebugItem debugItem) {
        switch (debugItem.getDebugItemType()) {
            case 3: {
                StartLocal startLocal = (StartLocal)debugItem;
                return new BuilderStartLocal(startLocal.getRegister(), startLocal.getNameReference(), startLocal.getTypeReference(), startLocal.getSignatureReference());
            }
            case 5: {
                EndLocal endLocal = (EndLocal)debugItem;
                return new BuilderEndLocal(endLocal.getRegister());
            }
            case 6: {
                RestartLocal restartLocal = (RestartLocal)debugItem;
                return new BuilderRestartLocal(restartLocal.getRegister());
            }
            case 7: {
                return new BuilderPrologueEnd();
            }
            case 8: {
                return new BuilderEpilogueBegin();
            }
            case 10: {
                LineNumber lineNumber = (LineNumber)debugItem;
                return new BuilderLineNumber(lineNumber.getLineNumber());
            }
            case 9: {
                SetSourceFile setSourceFile = (SetSourceFile)debugItem;
                return new BuilderSetSourceFile(setSourceFile.getSourceFileReference());
            }
        }
        throw new ExceptionWithContext("Invalid debug item type: " + debugItem.getDebugItemType(), new Object[0]);
    }

    private static class SwitchPayloadReferenceLabel
    extends Label {
        public MethodLocation switchLocation;

        private SwitchPayloadReferenceLabel() {
        }
    }

    private static interface Task {
        public void perform();
    }
}

