/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.com.google.common.collect;

import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableBiMap;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableSet;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.RegularImmutableMap;
import java.util.Map;

final class RegularImmutableBiMap<K, V>
extends ImmutableBiMap<K, V> {
    static final RegularImmutableBiMap<Object, Object> EMPTY = new RegularImmutableBiMap();
    private final transient int[] keyHashTable;
    final transient Object[] alternatingKeysAndValues;
    private final transient int keyOffset;
    private final transient int size;
    private final transient RegularImmutableBiMap<V, K> inverse;

    private RegularImmutableBiMap() {
        this.keyHashTable = null;
        this.alternatingKeysAndValues = new Object[0];
        this.keyOffset = 0;
        this.size = 0;
        this.inverse = this;
    }

    RegularImmutableBiMap(Object[] objectArray, int n) {
        this.alternatingKeysAndValues = objectArray;
        this.size = n;
        this.keyOffset = 0;
        int n2 = n >= 2 ? ImmutableSet.chooseTableSize(n) : 0;
        this.keyHashTable = RegularImmutableMap.createHashTable(objectArray, n, n2, 0);
        int[] nArray = RegularImmutableMap.createHashTable(objectArray, n, n2, 1);
        this.inverse = new RegularImmutableBiMap<K, V>(nArray, objectArray, n, this);
    }

    private RegularImmutableBiMap(int[] nArray, Object[] objectArray, int n, RegularImmutableBiMap<V, K> regularImmutableBiMap) {
        this.keyHashTable = nArray;
        this.alternatingKeysAndValues = objectArray;
        this.keyOffset = 1;
        this.size = n;
        this.inverse = regularImmutableBiMap;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public ImmutableBiMap<V, K> inverse() {
        return this.inverse;
    }

    @Override
    public V get(Object object) {
        return (V)RegularImmutableMap.get(this.keyHashTable, this.alternatingKeysAndValues, this.size, this.keyOffset, object);
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return new RegularImmutableMap.EntrySet(this, this.alternatingKeysAndValues, this.keyOffset, this.size);
    }

    @Override
    ImmutableSet<K> createKeySet() {
        RegularImmutableMap.KeysOrValuesAsList keysOrValuesAsList = new RegularImmutableMap.KeysOrValuesAsList(this.alternatingKeysAndValues, this.keyOffset, this.size);
        return new RegularImmutableMap.KeySet<Object>(this, keysOrValuesAsList);
    }

    @Override
    boolean isPartialView() {
        return false;
    }
}

