/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.com.google.common.collect;

import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Preconditions;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Hashing;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableCollection;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableList;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ObjectArrays;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.RegularImmutableSet;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Sets;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.SingletonImmutableSet;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.UnmodifiableIterator;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;

public abstract class ImmutableSet<E>
extends ImmutableCollection<E>
implements Set<E> {
    private transient ImmutableList<E> asList;

    public static <E> ImmutableSet<E> of() {
        return RegularImmutableSet.EMPTY;
    }

    public static <E> ImmutableSet<E> of(E e) {
        return new SingletonImmutableSet<E>(e);
    }

    private static <E> ImmutableSet<E> construct(int n, Object ... objectArray) {
        switch (n) {
            case 0: {
                return ImmutableSet.of();
            }
            case 1: {
                Object object = objectArray[0];
                return ImmutableSet.of(object);
            }
        }
        int n2 = ImmutableSet.chooseTableSize(n);
        Object[] objectArray2 = new Object[n2];
        int n3 = n2 - 1;
        int n4 = 0;
        int n5 = 0;
        block4: for (int i = 0; i < n; ++i) {
            Object object = ObjectArrays.checkElementNotNull(objectArray[i], i);
            int n6 = object.hashCode();
            int n7 = Hashing.smear(n6);
            while (true) {
                int n8;
                Object object2;
                if ((object2 = objectArray2[n8 = n7 & n3]) == null) {
                    objectArray[n5++] = object;
                    objectArray2[n8] = object;
                    n4 += n6;
                    continue block4;
                }
                if (object2.equals(object)) continue block4;
                ++n7;
            }
        }
        Arrays.fill(objectArray, n5, n, null);
        if (n5 == 1) {
            Object object = objectArray[0];
            return new SingletonImmutableSet<Object>(object, n4);
        }
        if (ImmutableSet.chooseTableSize(n5) < n2 / 2) {
            return ImmutableSet.construct(n5, objectArray);
        }
        Object[] objectArray3 = ImmutableSet.shouldTrim(n5, objectArray.length) ? Arrays.copyOf(objectArray, n5) : objectArray;
        return new RegularImmutableSet(objectArray3, n4, objectArray2, n3, n5);
    }

    private static boolean shouldTrim(int n, int n2) {
        return n < (n2 >> 1) + (n2 >> 2);
    }

    static int chooseTableSize(int n) {
        if ((n = Math.max(n, 2)) < 0x2CCCCCCC) {
            int n2 = Integer.highestOneBit(n - 1) << 1;
            while ((double)n2 * 0.7 < (double)n) {
                n2 <<= 1;
            }
            return n2;
        }
        Preconditions.checkArgument(n < 0x40000000, "collection too large");
        return 0x40000000;
    }

    public static <E> ImmutableSet<E> copyOf(Iterator<? extends E> iterator) {
        if (!iterator.hasNext()) {
            return ImmutableSet.of();
        }
        E e = iterator.next();
        if (!iterator.hasNext()) {
            return ImmutableSet.of(e);
        }
        return ((Builder)((Builder)new Builder().add((Object)e)).addAll(iterator)).build();
    }

    ImmutableSet() {
    }

    boolean isHashCodeFast() {
        return false;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ImmutableSet && this.isHashCodeFast() && ((ImmutableSet)object).isHashCodeFast() && this.hashCode() != object.hashCode()) {
            return false;
        }
        return Sets.equalsImpl(this, object);
    }

    @Override
    public int hashCode() {
        return Sets.hashCodeImpl(this);
    }

    @Override
    public abstract UnmodifiableIterator<E> iterator();

    @Override
    public ImmutableList<E> asList() {
        ImmutableList<E> immutableList = this.asList;
        return immutableList == null ? (this.asList = this.createAsList()) : immutableList;
    }

    ImmutableList<E> createAsList() {
        return ImmutableList.asImmutableList(this.toArray());
    }

    public static class Builder<E>
    extends ImmutableCollection.ArrayBasedBuilder<E> {
        Object[] hashTable;
        private int hashCode;

        public Builder() {
            super(4);
        }

        @Override
        public Builder<E> add(E e) {
            Preconditions.checkNotNull(e);
            if (this.hashTable != null && ImmutableSet.chooseTableSize(this.size) <= this.hashTable.length) {
                this.addDeduping(e);
                return this;
            }
            this.hashTable = null;
            super.add((Object)e);
            return this;
        }

        private void addDeduping(E e) {
            int n = this.hashTable.length - 1;
            int n2 = e.hashCode();
            int n3 = Hashing.smear(n2);
            while (true) {
                Object object;
                if ((object = this.hashTable[n3 &= n]) == null) {
                    this.hashTable[n3] = e;
                    this.hashCode += n2;
                    super.add((Object)e);
                    return;
                }
                if (object.equals(e)) {
                    return;
                }
                ++n3;
            }
        }

        @Override
        public Builder<E> addAll(Iterator<? extends E> iterator) {
            Preconditions.checkNotNull(iterator);
            while (iterator.hasNext()) {
                this.add((Object)iterator.next());
            }
            return this;
        }

        public ImmutableSet<E> build() {
            RegularImmutableSet regularImmutableSet;
            switch (this.size) {
                case 0: {
                    return ImmutableSet.of();
                }
                case 1: {
                    return ImmutableSet.of(this.contents[0]);
                }
            }
            if (this.hashTable != null && ImmutableSet.chooseTableSize(this.size) == this.hashTable.length) {
                Object[] objectArray = ImmutableSet.shouldTrim(this.size, this.contents.length) ? Arrays.copyOf(this.contents, this.size) : this.contents;
                regularImmutableSet = new RegularImmutableSet(objectArray, this.hashCode, this.hashTable, this.hashTable.length - 1, this.size);
            } else {
                regularImmutableSet = ImmutableSet.construct(this.size, this.contents);
                this.size = ((AbstractCollection)regularImmutableSet).size();
            }
            this.forceCopy = true;
            this.hashTable = null;
            return regularImmutableSet;
        }
    }
}

