/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.com.google.common.collect;

import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Preconditions;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Cut;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableList;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableMap;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableSortedMap;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Lists;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Maps;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Range;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.RangeMap;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.RegularImmutableSortedSet;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.SortedLists;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ImmutableRangeMap<K extends Comparable<?>, V>
implements RangeMap<K, V>,
Serializable {
    private static final ImmutableRangeMap<Comparable<?>, Object> EMPTY = new ImmutableRangeMap(ImmutableList.of(), ImmutableList.of());
    private final transient ImmutableList<Range<K>> ranges;
    private final transient ImmutableList<V> values;

    public static <K extends Comparable<?>, V> Builder<K, V> builder() {
        return new Builder();
    }

    ImmutableRangeMap(ImmutableList<Range<K>> immutableList, ImmutableList<V> immutableList2) {
        this.ranges = immutableList;
        this.values = immutableList2;
    }

    @Override
    public V get(K k) {
        int n = SortedLists.binarySearch(this.ranges, Range.lowerBoundFn(), Cut.belowValue(k), SortedLists.KeyPresentBehavior.ANY_PRESENT, SortedLists.KeyAbsentBehavior.NEXT_LOWER);
        if (n == -1) {
            return null;
        }
        Range range = (Range)this.ranges.get(n);
        return range.contains(k) ? (V)this.values.get(n) : null;
    }

    @Override
    public ImmutableMap<Range<K>, V> asMapOfRanges() {
        if (this.ranges.isEmpty()) {
            return ImmutableMap.of();
        }
        RegularImmutableSortedSet regularImmutableSortedSet = new RegularImmutableSortedSet(this.ranges, Range.rangeLexOrdering());
        return new ImmutableSortedMap(regularImmutableSortedSet, this.values);
    }

    public int hashCode() {
        return ((ImmutableMap)this.asMapOfRanges()).hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof RangeMap) {
            RangeMap rangeMap = (RangeMap)object;
            return ((ImmutableMap)this.asMapOfRanges()).equals(rangeMap.asMapOfRanges());
        }
        return false;
    }

    public String toString() {
        return ((ImmutableMap)this.asMapOfRanges()).toString();
    }

    public static final class Builder<K extends Comparable<?>, V> {
        private final List<Map.Entry<Range<K>, V>> entries = Lists.newArrayList();

        public Builder<K, V> put(Range<K> range, V v) {
            Preconditions.checkNotNull(range);
            Preconditions.checkNotNull(v);
            Preconditions.checkArgument(!range.isEmpty(), "Range must not be empty, but was %s", range);
            this.entries.add(Maps.immutableEntry(range, v));
            return this;
        }

        public ImmutableRangeMap<K, V> build() {
            Collections.sort(this.entries, Range.rangeLexOrdering().onKeys());
            ImmutableList.Builder builder = new ImmutableList.Builder(this.entries.size());
            ImmutableList.Builder builder2 = new ImmutableList.Builder(this.entries.size());
            for (int i = 0; i < this.entries.size(); ++i) {
                Range<K> range;
                Range<K> range2 = this.entries.get(i).getKey();
                if (i > 0 && range2.isConnected(range = this.entries.get(i - 1).getKey()) && !range2.intersection(range).isEmpty()) {
                    throw new IllegalArgumentException("Overlapping ranges: range " + range + " overlaps with entry " + range2);
                }
                builder.add(range2);
                builder2.add(this.entries.get(i).getValue());
            }
            return new ImmutableRangeMap(builder.build(), builder2.build());
        }
    }
}

