/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.util;

import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.FieldReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.MethodProtoReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.MethodReference;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public final class ReferenceUtil {
    public static String getMethodDescriptor(MethodReference methodReference) {
        return ReferenceUtil.getMethodDescriptor(methodReference, false);
    }

    public static String getMethodDescriptor(MethodReference methodReference, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!bl) {
            stringBuilder.append(methodReference.getDefiningClass());
            stringBuilder.append("->");
        }
        stringBuilder.append(methodReference.getName());
        stringBuilder.append('(');
        for (CharSequence charSequence : methodReference.getParameterTypes()) {
            stringBuilder.append(charSequence);
        }
        stringBuilder.append(')');
        stringBuilder.append(methodReference.getReturnType());
        return stringBuilder.toString();
    }

    public static String getMethodProtoDescriptor(MethodProtoReference methodProtoReference) {
        StringWriter stringWriter = new StringWriter();
        try {
            ReferenceUtil.writeMethodProtoDescriptor(stringWriter, methodProtoReference);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return stringWriter.toString();
    }

    public static void writeMethodProtoDescriptor(Writer writer, MethodProtoReference methodProtoReference) throws IOException {
        writer.write(40);
        for (CharSequence charSequence : methodProtoReference.getParameterTypes()) {
            writer.write(charSequence.toString());
        }
        writer.write(41);
        writer.write(methodProtoReference.getReturnType());
    }

    public static String getFieldDescriptor(FieldReference fieldReference) {
        return ReferenceUtil.getFieldDescriptor(fieldReference, false);
    }

    public static String getFieldDescriptor(FieldReference fieldReference, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!bl) {
            stringBuilder.append(fieldReference.getDefiningClass());
            stringBuilder.append("->");
        }
        stringBuilder.append(fieldReference.getName());
        stringBuilder.append(':');
        stringBuilder.append(fieldReference.getType());
        return stringBuilder.toString();
    }

    public static String getShortFieldDescriptor(FieldReference fieldReference) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(fieldReference.getName());
        stringBuilder.append(':');
        stringBuilder.append(fieldReference.getType());
        return stringBuilder.toString();
    }
}

