/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction;

import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcode;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedDexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.util.FixedSizeList;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.SwitchElement;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.SparseSwitchPayload;
import java.util.List;

public class DexBackedSparseSwitchPayload
extends DexBackedInstruction
implements SparseSwitchPayload {
    public final int elementCount;

    public DexBackedSparseSwitchPayload(DexBackedDexFile dexBackedDexFile, int n) {
        super(dexBackedDexFile, Opcode.SPARSE_SWITCH_PAYLOAD, n);
        this.elementCount = dexBackedDexFile.getDataBuffer().readUshort(n + 2);
    }

    @Override
    public List<? extends SwitchElement> getSwitchElements() {
        return new FixedSizeList<SwitchElement>(){

            @Override
            public SwitchElement readItem(final int n) {
                return new SwitchElement(){

                    @Override
                    public int getKey() {
                        return DexBackedSparseSwitchPayload.this.dexFile.getDataBuffer().readInt(DexBackedSparseSwitchPayload.this.instructionStart + 4 + n * 4);
                    }

                    @Override
                    public int getOffset() {
                        return DexBackedSparseSwitchPayload.this.dexFile.getDataBuffer().readInt(DexBackedSparseSwitchPayload.this.instructionStart + 4 + DexBackedSparseSwitchPayload.this.elementCount * 4 + n * 4);
                    }
                };
            }

            @Override
            public int size() {
                return DexBackedSparseSwitchPayload.this.elementCount;
            }
        };
    }

    @Override
    public int getCodeUnits() {
        return 2 + this.elementCount * 4;
    }
}

