/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked;

import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableList;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableSet;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.base.reference.BaseTypeReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedAnnotation;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedDexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedField;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedMethod;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexReader;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.util.AnnotationsDirectory;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.util.EncodedArrayItemIterator;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.util.VariableSizeLookaheadIterator;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.ClassDef;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.FieldReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.MethodReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.reference.ImmutableFieldReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.reference.ImmutableMethodReference;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DexBackedClassDef
extends BaseTypeReference
implements ClassDef {
    public final DexBackedDexFile dexFile;
    private final int classDefOffset;
    private final int staticFieldsOffset;
    private int instanceFieldsOffset = 0;
    private int directMethodsOffset = 0;
    private int virtualMethodsOffset = 0;
    private final int staticFieldCount;
    private final int instanceFieldCount;
    private final int directMethodCount;
    private final int virtualMethodCount;
    private AnnotationsDirectory annotationsDirectory;

    public DexBackedClassDef(DexBackedDexFile dexBackedDexFile, int n) {
        this.dexFile = dexBackedDexFile;
        this.classDefOffset = n;
        int n2 = dexBackedDexFile.getBuffer().readSmallUint(n + 24);
        if (n2 == 0) {
            this.staticFieldsOffset = -1;
            this.staticFieldCount = 0;
            this.instanceFieldCount = 0;
            this.directMethodCount = 0;
            this.virtualMethodCount = 0;
        } else {
            DexReader dexReader = dexBackedDexFile.getDataBuffer().readerAt(n2);
            this.staticFieldCount = dexReader.readSmallUleb128();
            this.instanceFieldCount = dexReader.readSmallUleb128();
            this.directMethodCount = dexReader.readSmallUleb128();
            this.virtualMethodCount = dexReader.readSmallUleb128();
            this.staticFieldsOffset = dexReader.getOffset();
        }
    }

    @Override
    public String getType() {
        return (String)this.dexFile.getTypeSection().get(this.dexFile.getBuffer().readSmallUint(this.classDefOffset + 0));
    }

    @Override
    public String getSuperclass() {
        return this.dexFile.getTypeSection().getOptional(this.dexFile.getBuffer().readOptionalUint(this.classDefOffset + 8));
    }

    @Override
    public int getAccessFlags() {
        return this.dexFile.getBuffer().readSmallUint(this.classDefOffset + 4);
    }

    @Override
    public String getSourceFile() {
        return this.dexFile.getStringSection().getOptional(this.dexFile.getBuffer().readOptionalUint(this.classDefOffset + 16));
    }

    @Override
    public List<String> getInterfaces() {
        final int n = this.dexFile.getBuffer().readSmallUint(this.classDefOffset + 12);
        if (n > 0) {
            final int n2 = this.dexFile.getDataBuffer().readSmallUint(n);
            return new AbstractList<String>(){

                @Override
                public String get(int n3) {
                    return (String)DexBackedClassDef.this.dexFile.getTypeSection().get(DexBackedClassDef.this.dexFile.getDataBuffer().readUshort(n + 4 + 2 * n3));
                }

                @Override
                public int size() {
                    return n2;
                }
            };
        }
        return ImmutableList.of();
    }

    public Set<? extends DexBackedAnnotation> getAnnotations() {
        return this.getAnnotationsDirectory().getClassAnnotations();
    }

    public Iterable<? extends DexBackedField> getStaticFields() {
        return this.getStaticFields(true);
    }

    public Iterable<? extends DexBackedField> getStaticFields(final boolean bl) {
        if (this.staticFieldCount > 0) {
            DexReader dexReader = this.dexFile.getDataBuffer().readerAt(this.staticFieldsOffset);
            final AnnotationsDirectory annotationsDirectory = this.getAnnotationsDirectory();
            final int n = this.dexFile.getBuffer().readSmallUint(this.classDefOffset + 28);
            final int n2 = dexReader.getOffset();
            return new Iterable<DexBackedField>(){

                @Override
                public Iterator<DexBackedField> iterator() {
                    final AnnotationsDirectory.AnnotationIterator annotationIterator = annotationsDirectory.getFieldAnnotationIterator();
                    final EncodedArrayItemIterator encodedArrayItemIterator = EncodedArrayItemIterator.newOrEmpty(DexBackedClassDef.this.dexFile, n);
                    return new VariableSizeLookaheadIterator<DexBackedField>(DexBackedClassDef.this.dexFile.getDataBuffer(), n2){
                        private int count;
                        private FieldReference previousField;
                        private int previousIndex;

                        @Override
                        protected DexBackedField readNextItem(DexReader dexReader) {
                            DexBackedField dexBackedField;
                            ImmutableFieldReference immutableFieldReference;
                            FieldReference fieldReference;
                            do {
                                if (++this.count > DexBackedClassDef.this.staticFieldCount) {
                                    DexBackedClassDef.this.instanceFieldsOffset = dexReader.getOffset();
                                    return (DexBackedField)this.endOfData();
                                }
                                dexBackedField = new DexBackedField(DexBackedClassDef.this.dexFile, dexReader, DexBackedClassDef.this, this.previousIndex, encodedArrayItemIterator, annotationIterator);
                                fieldReference = this.previousField;
                                immutableFieldReference = ImmutableFieldReference.of(dexBackedField);
                                this.previousField = immutableFieldReference;
                                this.previousIndex = dexBackedField.fieldIndex;
                            } while (bl && fieldReference != null && fieldReference.equals(immutableFieldReference));
                            return dexBackedField;
                        }
                    };
                }
            };
        }
        this.instanceFieldsOffset = this.staticFieldsOffset;
        return ImmutableSet.of();
    }

    public Iterable<? extends DexBackedField> getInstanceFields() {
        return this.getInstanceFields(true);
    }

    public Iterable<? extends DexBackedField> getInstanceFields(final boolean bl) {
        if (this.instanceFieldCount > 0) {
            DexReader dexReader = this.dexFile.getDataBuffer().readerAt(this.getInstanceFieldsOffset());
            final AnnotationsDirectory annotationsDirectory = this.getAnnotationsDirectory();
            final int n = dexReader.getOffset();
            return new Iterable<DexBackedField>(){

                @Override
                public Iterator<DexBackedField> iterator() {
                    final AnnotationsDirectory.AnnotationIterator annotationIterator = annotationsDirectory.getFieldAnnotationIterator();
                    return new VariableSizeLookaheadIterator<DexBackedField>(DexBackedClassDef.this.dexFile.getDataBuffer(), n){
                        private int count;
                        private FieldReference previousField;
                        private int previousIndex;

                        @Override
                        protected DexBackedField readNextItem(DexReader dexReader) {
                            DexBackedField dexBackedField;
                            ImmutableFieldReference immutableFieldReference;
                            FieldReference fieldReference;
                            do {
                                if (++this.count > DexBackedClassDef.this.instanceFieldCount) {
                                    DexBackedClassDef.this.directMethodsOffset = dexReader.getOffset();
                                    return (DexBackedField)this.endOfData();
                                }
                                dexBackedField = new DexBackedField(DexBackedClassDef.this.dexFile, dexReader, DexBackedClassDef.this, this.previousIndex, annotationIterator);
                                fieldReference = this.previousField;
                                immutableFieldReference = ImmutableFieldReference.of(dexBackedField);
                                this.previousField = immutableFieldReference;
                                this.previousIndex = dexBackedField.fieldIndex;
                            } while (bl && fieldReference != null && fieldReference.equals(immutableFieldReference));
                            return dexBackedField;
                        }
                    };
                }
            };
        }
        if (this.instanceFieldsOffset > 0) {
            this.directMethodsOffset = this.instanceFieldsOffset;
        }
        return ImmutableSet.of();
    }

    public Iterable<? extends DexBackedMethod> getDirectMethods() {
        return this.getDirectMethods(true);
    }

    public Iterable<? extends DexBackedMethod> getDirectMethods(final boolean bl) {
        if (this.directMethodCount > 0) {
            DexReader dexReader = this.dexFile.getDataBuffer().readerAt(this.getDirectMethodsOffset());
            final AnnotationsDirectory annotationsDirectory = this.getAnnotationsDirectory();
            final int n = dexReader.getOffset();
            return new Iterable<DexBackedMethod>(){

                @Override
                public Iterator<DexBackedMethod> iterator() {
                    final AnnotationsDirectory.AnnotationIterator annotationIterator = annotationsDirectory.getMethodAnnotationIterator();
                    final AnnotationsDirectory.AnnotationIterator annotationIterator2 = annotationsDirectory.getParameterAnnotationIterator();
                    return new VariableSizeLookaheadIterator<DexBackedMethod>(DexBackedClassDef.this.dexFile.getDataBuffer(), n){
                        private int count;
                        private MethodReference previousMethod;
                        private int previousIndex;

                        @Override
                        protected DexBackedMethod readNextItem(DexReader dexReader) {
                            DexBackedMethod dexBackedMethod;
                            ImmutableMethodReference immutableMethodReference;
                            MethodReference methodReference;
                            do {
                                if (++this.count > DexBackedClassDef.this.directMethodCount) {
                                    DexBackedClassDef.this.virtualMethodsOffset = dexReader.getOffset();
                                    return (DexBackedMethod)this.endOfData();
                                }
                                dexBackedMethod = new DexBackedMethod(DexBackedClassDef.this.dexFile, dexReader, DexBackedClassDef.this, this.previousIndex, annotationIterator, annotationIterator2);
                                methodReference = this.previousMethod;
                                immutableMethodReference = ImmutableMethodReference.of(dexBackedMethod);
                                this.previousMethod = immutableMethodReference;
                                this.previousIndex = dexBackedMethod.methodIndex;
                            } while (bl && methodReference != null && methodReference.equals(immutableMethodReference));
                            return dexBackedMethod;
                        }
                    };
                }
            };
        }
        if (this.directMethodsOffset > 0) {
            this.virtualMethodsOffset = this.directMethodsOffset;
        }
        return ImmutableSet.of();
    }

    public Iterable<? extends DexBackedMethod> getVirtualMethods(final boolean bl) {
        if (this.virtualMethodCount > 0) {
            DexReader dexReader = this.dexFile.getDataBuffer().readerAt(this.getVirtualMethodsOffset());
            final AnnotationsDirectory annotationsDirectory = this.getAnnotationsDirectory();
            final int n = dexReader.getOffset();
            return new Iterable<DexBackedMethod>(){
                final AnnotationsDirectory.AnnotationIterator methodAnnotationIterator;
                final AnnotationsDirectory.AnnotationIterator parameterAnnotationIterator;
                {
                    this.methodAnnotationIterator = annotationsDirectory.getMethodAnnotationIterator();
                    this.parameterAnnotationIterator = annotationsDirectory.getParameterAnnotationIterator();
                }

                @Override
                public Iterator<DexBackedMethod> iterator() {
                    return new VariableSizeLookaheadIterator<DexBackedMethod>(DexBackedClassDef.this.dexFile.getDataBuffer(), n){
                        private int count;
                        private MethodReference previousMethod;
                        private int previousIndex;

                        @Override
                        protected DexBackedMethod readNextItem(DexReader dexReader) {
                            DexBackedMethod dexBackedMethod;
                            ImmutableMethodReference immutableMethodReference;
                            MethodReference methodReference;
                            do {
                                if (++this.count > DexBackedClassDef.this.virtualMethodCount) {
                                    return (DexBackedMethod)this.endOfData();
                                }
                                dexBackedMethod = new DexBackedMethod(DexBackedClassDef.this.dexFile, dexReader, DexBackedClassDef.this, this.previousIndex, methodAnnotationIterator, parameterAnnotationIterator);
                                methodReference = this.previousMethod;
                                immutableMethodReference = ImmutableMethodReference.of(dexBackedMethod);
                                this.previousMethod = immutableMethodReference;
                                this.previousIndex = dexBackedMethod.methodIndex;
                            } while (bl && methodReference != null && methodReference.equals(immutableMethodReference));
                            return dexBackedMethod;
                        }
                    };
                }
            };
        }
        return ImmutableSet.of();
    }

    public Iterable<? extends DexBackedMethod> getVirtualMethods() {
        return this.getVirtualMethods(true);
    }

    private AnnotationsDirectory getAnnotationsDirectory() {
        if (this.annotationsDirectory == null) {
            int n = this.dexFile.getBuffer().readSmallUint(this.classDefOffset + 20);
            this.annotationsDirectory = AnnotationsDirectory.newOrEmpty(this.dexFile, n);
        }
        return this.annotationsDirectory;
    }

    private int getInstanceFieldsOffset() {
        if (this.instanceFieldsOffset > 0) {
            return this.instanceFieldsOffset;
        }
        DexReader dexReader = this.dexFile.getDataBuffer().readerAt(this.staticFieldsOffset);
        DexBackedField.skipFields(dexReader, this.staticFieldCount);
        this.instanceFieldsOffset = dexReader.getOffset();
        return this.instanceFieldsOffset;
    }

    private int getDirectMethodsOffset() {
        if (this.directMethodsOffset > 0) {
            return this.directMethodsOffset;
        }
        DexReader dexReader = this.dexFile.getDataBuffer().readerAt(this.getInstanceFieldsOffset());
        DexBackedField.skipFields(dexReader, this.instanceFieldCount);
        this.directMethodsOffset = dexReader.getOffset();
        return this.directMethodsOffset;
    }

    private int getVirtualMethodsOffset() {
        if (this.virtualMethodsOffset > 0) {
            return this.virtualMethodsOffset;
        }
        DexReader dexReader = this.dexFile.getDataBuffer().readerAt(this.getDirectMethodsOffset());
        DexBackedMethod.skipMethods(dexReader, this.directMethodCount);
        this.virtualMethodsOffset = dexReader.getOffset();
        return this.virtualMethodsOffset;
    }
}

