/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.reference;

import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableList;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.base.reference.BaseMethodReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedDexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.util.FixedSizeList;
import java.util.List;

public class DexBackedMethodReference
extends BaseMethodReference {
    public final DexBackedDexFile dexFile;
    public final int methodIdItemOffset;
    private int protoIdItemOffset;

    public DexBackedMethodReference(DexBackedDexFile dexBackedDexFile, int n) {
        this.dexFile = dexBackedDexFile;
        this.methodIdItemOffset = dexBackedDexFile.getMethodIdItemOffset(n);
    }

    @Override
    public String getDefiningClass() {
        return this.dexFile.getType(this.dexFile.readUshort(this.methodIdItemOffset + 0));
    }

    @Override
    public String getName() {
        return this.dexFile.getString(this.dexFile.readSmallUint(this.methodIdItemOffset + 4));
    }

    public List<String> getParameterTypes() {
        int n = this.getProtoIdItemOffset();
        int n2 = this.dexFile.readSmallUint(n + 8);
        if (n2 > 0) {
            final int n3 = this.dexFile.readSmallUint(n2 + 0);
            final int n4 = n2 + 4;
            return new FixedSizeList<String>(){

                @Override
                public String readItem(int n) {
                    return DexBackedMethodReference.this.dexFile.getType(DexBackedMethodReference.this.dexFile.readUshort(n4 + 2 * n));
                }

                @Override
                public int size() {
                    return n3;
                }
            };
        }
        return ImmutableList.of();
    }

    @Override
    public String getReturnType() {
        int n = this.getProtoIdItemOffset();
        return this.dexFile.getType(this.dexFile.readSmallUint(n + 4));
    }

    private int getProtoIdItemOffset() {
        if (this.protoIdItemOffset == 0) {
            this.protoIdItemOffset = this.dexFile.getProtoIdItemOffset(this.dexFile.readUshort(this.methodIdItemOffset + 2));
        }
        return this.protoIdItemOffset;
    }
}

