/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.instruction;

import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Format;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcode;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.BuilderInstruction;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction35c;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.Reference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.util.Preconditions;

public class BuilderInstruction35c
extends BuilderInstruction
implements Instruction35c {
    public static final Format FORMAT = Format.Format35c;
    protected final int registerCount;
    protected final int registerC;
    protected final int registerD;
    protected final int registerE;
    protected final int registerF;
    protected final int registerG;
    protected final Reference reference;

    public BuilderInstruction35c(Opcode opcode, int n, int n2, int n3, int n4, int n5, int n6, Reference reference) {
        super(opcode);
        this.registerCount = Preconditions.check35cAnd45ccRegisterCount(n);
        this.registerC = n > 0 ? Preconditions.checkNibbleRegister(n2) : 0;
        this.registerD = n > 1 ? Preconditions.checkNibbleRegister(n3) : 0;
        this.registerE = n > 2 ? Preconditions.checkNibbleRegister(n4) : 0;
        this.registerF = n > 3 ? Preconditions.checkNibbleRegister(n5) : 0;
        this.registerG = n > 4 ? Preconditions.checkNibbleRegister(n6) : 0;
        this.reference = reference;
    }

    @Override
    public int getRegisterCount() {
        return this.registerCount;
    }

    @Override
    public int getRegisterC() {
        return this.registerC;
    }

    @Override
    public int getRegisterD() {
        return this.registerD;
    }

    @Override
    public int getRegisterE() {
        return this.registerE;
    }

    @Override
    public int getRegisterF() {
        return this.registerF;
    }

    @Override
    public int getRegisterG() {
        return this.registerG;
    }

    @Override
    public Reference getReference() {
        return this.reference;
    }

    @Override
    public int getReferenceType() {
        return this.opcode.referenceType;
    }

    @Override
    public Format getFormat() {
        return FORMAT;
    }
}

