/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.com.google.common.base;

import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Function;
import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Objects;
import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Preconditions;
import java.io.Serializable;

public final class Functions {
    private Functions() {
    }

    public static Function<Object, String> toStringFunction() {
        return ToStringFunction.INSTANCE;
    }

    public static <E> Function<Object, E> constant(E e) {
        return new ConstantFunction<E>(e);
    }

    private static class ConstantFunction<E>
    implements Function<Object, E>,
    Serializable {
        private final E value;

        public ConstantFunction(E e) {
            this.value = e;
        }

        @Override
        public E apply(Object object) {
            return this.value;
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof ConstantFunction) {
                ConstantFunction constantFunction = (ConstantFunction)object;
                return Objects.equal(this.value, constantFunction.value);
            }
            return false;
        }

        public int hashCode() {
            return this.value == null ? 0 : this.value.hashCode();
        }

        public String toString() {
            String string = String.valueOf(String.valueOf(this.value));
            return new StringBuilder(10 + string.length()).append("constant(").append(string).append(")").toString();
        }
    }

    private static final class ToStringFunction
    extends Enum<ToStringFunction>
    implements Function<Object, String> {
        public static final /* enum */ ToStringFunction INSTANCE = new ToStringFunction();
        private static final /* synthetic */ ToStringFunction[] $VALUES;

        @Override
        public String apply(Object object) {
            Preconditions.checkNotNull(object);
            return object.toString();
        }

        public String toString() {
            return "toString";
        }

        static {
            $VALUES = new ToStringFunction[]{INSTANCE};
        }
    }
}

