/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.raw;

import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.VersionMap;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.BaseDexBuffer;

public class HeaderItem {
    private static final byte[] MAGIC_VALUE = new byte[]{100, 101, 120, 10, 0, 0, 0, 0};

    public static byte[] getMagicForApi(int n) {
        return HeaderItem.getMagicForDexVersion(VersionMap.mapApiToDexVersion(n));
    }

    public static byte[] getMagicForDexVersion(int n) {
        byte[] byArray = (byte[])MAGIC_VALUE.clone();
        if (n < 0 || n > 999) {
            throw new IllegalArgumentException("dexVersion must be within [0, 999]");
        }
        for (int i = 6; i >= 4; --i) {
            int n2 = n % 10;
            byArray[i] = (byte)(48 + n2);
            n /= 10;
        }
        return byArray;
    }

    public static boolean verifyMagic(byte[] byArray, int n) {
        int n2;
        if (byArray.length - n < 8) {
            return false;
        }
        for (n2 = 0; n2 < 4; ++n2) {
            if (byArray[n + n2] == MAGIC_VALUE[n2]) continue;
            return false;
        }
        for (n2 = 4; n2 < 7; ++n2) {
            if (byArray[n + n2] >= 48 && byArray[n + n2] <= 57) continue;
            return false;
        }
        return byArray[n + 7] == MAGIC_VALUE[7];
    }

    public static int getVersion(byte[] byArray, int n) {
        if (!HeaderItem.verifyMagic(byArray, n)) {
            return -1;
        }
        return HeaderItem.getVersionUnchecked(byArray, n);
    }

    private static int getVersionUnchecked(byte[] byArray, int n) {
        int n2 = (byArray[n + 4] - 48) * 100;
        n2 += (byArray[n + 5] - 48) * 10;
        return n2 += byArray[n + 6] - 48;
    }

    public static boolean isSupportedDexVersion(int n) {
        return VersionMap.mapDexVersionToApi(n) != -1;
    }

    public static int getEndian(byte[] byArray, int n) {
        BaseDexBuffer baseDexBuffer = new BaseDexBuffer(byArray);
        return baseDexBuffer.readInt(n + 40);
    }
}

