/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import android.content.Context;
import android.os.Build;
import com.github.tmurakami.dexopener.ClassTransformer;
import com.github.tmurakami.dexopener.DexFileLoader;
import com.github.tmurakami.dexopener.FileUtils;
import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Function;
import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Functions;
import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Predicate;
import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Predicates;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Iterables;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Maps;
import com.github.tmurakami.dexopener.repackaged.com.google.common.io.ByteStreams;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcodes;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.analysis.reflection.util.ReflectionUtils;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedDexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.ClassDef;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.DexFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class ClassPath {
    private static final int MAX_CLASSES_PER_DEX_FILE = 100;
    private final Context context;
    private final Predicate<? super String> dexNameFilter;
    private final DexFileLoader dexFileLoader;
    private final Executor executor;
    private Map<String, dalvik.system.DexFile> dexFileMap;

    ClassPath(Context context, Predicate<? super String> dexNameFilter, DexFileLoader dexFileLoader, Executor executor) {
        this.context = context;
        this.dexNameFilter = dexNameFilter;
        this.dexFileLoader = dexFileLoader;
        this.executor = executor;
    }

    Class loadClass(String className, ClassLoader loader) {
        dalvik.system.DexFile dexFile = this.getDexFileFor(className);
        return dexFile == null ? null : dexFile.loadClass(className, loader);
    }

    private dalvik.system.DexFile getDexFileFor(String className) {
        String dexName = ReflectionUtils.javaToDexName((String)className);
        if (!this.dexNameFilter.apply((Object)dexName)) {
            return null;
        }
        Map<String, dalvik.system.DexFile> map = this.dexFileMap;
        if (map == null) {
            this.dexFileMap = map = this.collectDexFiles();
        }
        return map.get(dexName);
    }

    private Map<String, dalvik.system.DexFile> collectDexFiles() {
        File codeCacheDir = ClassPath.getCodeCacheDir(this.context);
        Predicate classDefFilter = Predicates.compose(this.dexNameFilter, ClassDef::getType);
        HashMap futureMap = new HashMap();
        String sourceDir = this.context.getApplicationInfo().sourceDir;
        try (ZipFile zipFile = new ZipFile(sourceDir);){
            for (DexFile dexFile : ClassPath.dexFiles(zipFile)) {
                Opcodes opcodes = dexFile.getOpcodes();
                Iterable classes = Iterables.filter((Iterable)dexFile.getClasses(), (Predicate)classDefFilter);
                for (List list : Iterables.partition((Iterable)classes, (int)100)) {
                    HashSet set = new HashSet(list);
                    ClassTransformer transformer = new ClassTransformer(opcodes, set, codeCacheDir, this.dexFileLoader);
                    FutureTask<dalvik.system.DexFile> future = new FutureTask<dalvik.system.DexFile>(transformer);
                    this.executor.execute(future);
                    futureMap.putAll(Maps.toMap((Iterable)Iterables.transform(set, ClassDef::getType), (Function)Functions.constant(future)));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Maps.transformValues(futureMap, ClassPath.runnableFutureResult());
    }

    private static File getCodeCacheDir(Context context) {
        File parentDir = Build.VERSION.SDK_INT < 21 ? new File(context.getApplicationInfo().dataDir, "code_cache") : context.getCodeCacheDir();
        File cacheDir = new File(parentDir, "dexopener");
        if (cacheDir.isDirectory() || cacheDir.mkdirs()) {
            FileUtils.delete(cacheDir.listFiles());
        }
        return cacheDir;
    }

    private static Iterable<DexFile> dexFiles(ZipFile zipFile) {
        return Iterables.transform((Iterable)Iterables.filter(Collections.list(zipFile.entries()), entry -> {
            String name = entry.getName();
            return name.startsWith("classes") && name.endsWith(".dex");
        }), entry -> {
            try (InputStream in = zipFile.getInputStream((ZipEntry)entry);){
                DexBackedDexFile dexBackedDexFile = new DexBackedDexFile(null, ByteStreams.toByteArray((InputStream)in));
                return dexBackedDexFile;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static <T> Function<RunnableFuture<T>, T> runnableFutureResult() {
        return future -> {
            future.run();
            boolean interrupted = false;
            while (true) {
                try {
                    Object v = future.get();
                    return v;
                }
                catch (InterruptedException e) {
                    try {
                        interrupted = true;
                        continue;
                    }
                    catch (ExecutionException e2) {
                        Throwable cause = e2.getCause();
                        if (cause instanceof RuntimeException) {
                            throw (RuntimeException)cause;
                        }
                        if (cause instanceof Error) {
                            throw (Error)cause;
                        }
                        throw new RuntimeException(cause);
                    }
                }
                break;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        };
    }
}

