/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class RandomAccessFileOutputStream
extends OutputStream {
    private int filePosition;
    private final RandomAccessFile raf;

    public RandomAccessFileOutputStream(RandomAccessFile randomAccessFile, int n) {
        this.filePosition = n;
        this.raf = randomAccessFile;
    }

    @Override
    public void write(int n) throws IOException {
        this.raf.seek(this.filePosition);
        ++this.filePosition;
        this.raf.write(n);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.raf.seek(this.filePosition);
        this.filePosition += byArray.length;
        this.raf.write(byArray);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.raf.seek(this.filePosition);
        this.filePosition += n2;
        this.raf.write(byArray, n, n2);
    }
}

