/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction;

import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcode;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedDexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.util.FixedSizeList;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.SwitchElement;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.PackedSwitchPayload;
import java.util.List;

public class DexBackedPackedSwitchPayload
extends DexBackedInstruction
implements PackedSwitchPayload {
    public final int elementCount;

    public DexBackedPackedSwitchPayload(DexBackedDexFile dexBackedDexFile, int n) {
        super(dexBackedDexFile, Opcode.PACKED_SWITCH_PAYLOAD, n);
        this.elementCount = dexBackedDexFile.readUshort(n + 2);
    }

    @Override
    public List<? extends SwitchElement> getSwitchElements() {
        final int n = this.dexFile.readInt(this.instructionStart + 4);
        return new FixedSizeList<SwitchElement>(){

            @Override
            public SwitchElement readItem(final int n2) {
                return new SwitchElement(){

                    @Override
                    public int getKey() {
                        return n + n2;
                    }

                    @Override
                    public int getOffset() {
                        return DexBackedPackedSwitchPayload.this.dexFile.readInt(DexBackedPackedSwitchPayload.this.instructionStart + 8 + n2 * 4);
                    }
                };
            }

            @Override
            public int size() {
                return DexBackedPackedSwitchPayload.this.elementCount;
            }
        };
    }

    @Override
    public int getCodeUnits() {
        return 4 + this.elementCount * 2;
    }
}

