/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.com.google.common.collect;

import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Preconditions;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.AbstractMapEntry;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Cut;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Maps;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Range;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.RangeMap;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;

public final class TreeRangeMap<K extends Comparable, V>
implements RangeMap<K, V> {
    private final NavigableMap<Cut<K>, RangeMapEntry<K, V>> entriesByLowerBound = Maps.newTreeMap();
    private static final RangeMap EMPTY_SUB_RANGE_MAP = new RangeMap(){

        public Object get(Comparable comparable) {
            return null;
        }

        public void put(Range range, Object object) {
            Preconditions.checkNotNull(range);
            String string = String.valueOf(String.valueOf(range));
            throw new IllegalArgumentException(new StringBuilder(46 + string.length()).append("Cannot insert range ").append(string).append(" into an empty subRangeMap").toString());
        }

        public Map<Range, Object> asMapOfRanges() {
            return Collections.emptyMap();
        }
    };

    public static <K extends Comparable, V> TreeRangeMap<K, V> create() {
        return new TreeRangeMap<K, V>();
    }

    private TreeRangeMap() {
    }

    @Override
    public V get(K k) {
        Map.Entry<Range<K>, V> entry = this.getEntry(k);
        return entry == null ? null : (V)entry.getValue();
    }

    public Map.Entry<Range<K>, V> getEntry(K k) {
        Map.Entry<Cut<K>, RangeMapEntry<K, V>> entry = this.entriesByLowerBound.floorEntry(Cut.belowValue(k));
        if (entry != null && entry.getValue().contains(k)) {
            return entry.getValue();
        }
        return null;
    }

    @Override
    public void put(Range<K> range, V v) {
        if (!range.isEmpty()) {
            Preconditions.checkNotNull(v);
            this.remove(range);
            this.entriesByLowerBound.put(range.lowerBound, new RangeMapEntry<K, V>(range, v));
        }
    }

    private void putRangeMapEntry(Cut<K> cut, Cut<K> cut2, V v) {
        this.entriesByLowerBound.put(cut, new RangeMapEntry<K, V>(cut, cut2, v));
    }

    public void remove(Range<K> range) {
        RangeMapEntry rangeMapEntry;
        Map.Entry<Range<Object>, Object> entry;
        if (range.isEmpty()) {
            return;
        }
        Map.Entry entry2 = this.entriesByLowerBound.lowerEntry(range.lowerBound);
        if (entry2 != null && ((RangeMapEntry)(entry = entry2.getValue())).getUpperBound().compareTo(range.lowerBound) > 0) {
            if (((RangeMapEntry)entry).getUpperBound().compareTo(range.upperBound) > 0) {
                this.putRangeMapEntry(range.upperBound, ((RangeMapEntry)entry).getUpperBound(), entry2.getValue().getValue());
            }
            this.putRangeMapEntry(((RangeMapEntry)entry).getLowerBound(), range.lowerBound, entry2.getValue().getValue());
        }
        if ((entry = this.entriesByLowerBound.lowerEntry(range.upperBound)) != null && (rangeMapEntry = (RangeMapEntry)entry.getValue()).getUpperBound().compareTo(range.upperBound) > 0) {
            this.putRangeMapEntry(range.upperBound, rangeMapEntry.getUpperBound(), ((RangeMapEntry)entry.getValue()).getValue());
            this.entriesByLowerBound.remove(range.lowerBound);
        }
        this.entriesByLowerBound.subMap(range.lowerBound, range.upperBound).clear();
    }

    @Override
    public Map<Range<K>, V> asMapOfRanges() {
        return new AsMapOfRanges();
    }

    public boolean equals(Object object) {
        if (object instanceof RangeMap) {
            RangeMap rangeMap = (RangeMap)object;
            return this.asMapOfRanges().equals(rangeMap.asMapOfRanges());
        }
        return false;
    }

    public int hashCode() {
        return this.asMapOfRanges().hashCode();
    }

    public String toString() {
        return this.entriesByLowerBound.values().toString();
    }

    private final class AsMapOfRanges
    extends AbstractMap<Range<K>, V> {
        private AsMapOfRanges() {
        }

        @Override
        public boolean containsKey(Object object) {
            return this.get(object) != null;
        }

        @Override
        public V get(Object object) {
            if (object instanceof Range) {
                Range range = (Range)object;
                RangeMapEntry rangeMapEntry = (RangeMapEntry)TreeRangeMap.this.entriesByLowerBound.get(range.lowerBound);
                if (rangeMapEntry != null && ((Range)rangeMapEntry.getKey()).equals(range)) {
                    return rangeMapEntry.getValue();
                }
            }
            return null;
        }

        @Override
        public Set<Map.Entry<Range<K>, V>> entrySet() {
            return new AbstractSet<Map.Entry<Range<K>, V>>(){

                @Override
                public Iterator<Map.Entry<Range<K>, V>> iterator() {
                    return TreeRangeMap.this.entriesByLowerBound.values().iterator();
                }

                @Override
                public int size() {
                    return TreeRangeMap.this.entriesByLowerBound.size();
                }
            };
        }
    }

    private static final class RangeMapEntry<K extends Comparable, V>
    extends AbstractMapEntry<Range<K>, V> {
        private final Range<K> range;
        private final V value;

        RangeMapEntry(Cut<K> cut, Cut<K> cut2, V v) {
            this(Range.create(cut, cut2), v);
        }

        RangeMapEntry(Range<K> range, V v) {
            this.range = range;
            this.value = v;
        }

        @Override
        public Range<K> getKey() {
            return this.range;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        public boolean contains(K k) {
            return this.range.contains(k);
        }

        Cut<K> getLowerBound() {
            return this.range.lowerBound;
        }

        Cut<K> getUpperBound() {
            return this.range.upperBound;
        }
    }
}

