/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.com.google.common.collect;

import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Preconditions;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Cut;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableList;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableMap;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Range;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.RangeMap;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.RangeSet;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.RegularImmutableSortedMap;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.RegularImmutableSortedSet;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.SortedLists;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.TreeRangeMap;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.TreeRangeSet;
import java.util.Map;

public class ImmutableRangeMap<K extends Comparable<?>, V>
implements RangeMap<K, V> {
    private static final ImmutableRangeMap<Comparable<?>, Object> EMPTY = new ImmutableRangeMap(ImmutableList.of(), ImmutableList.of());
    private final ImmutableList<Range<K>> ranges;
    private final ImmutableList<V> values;

    public static <K extends Comparable<?>, V> Builder<K, V> builder() {
        return new Builder();
    }

    ImmutableRangeMap(ImmutableList<Range<K>> immutableList, ImmutableList<V> immutableList2) {
        this.ranges = immutableList;
        this.values = immutableList2;
    }

    @Override
    public V get(K k) {
        int n = SortedLists.binarySearch(this.ranges, Range.lowerBoundFn(), Cut.belowValue(k), SortedLists.KeyPresentBehavior.ANY_PRESENT, SortedLists.KeyAbsentBehavior.NEXT_LOWER);
        if (n == -1) {
            return null;
        }
        Range range = (Range)this.ranges.get(n);
        return range.contains(k) ? (V)this.values.get(n) : null;
    }

    @Override
    public void put(Range<K> range, V v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ImmutableMap<Range<K>, V> asMapOfRanges() {
        if (this.ranges.isEmpty()) {
            return ImmutableMap.of();
        }
        RegularImmutableSortedSet regularImmutableSortedSet = new RegularImmutableSortedSet(this.ranges, Range.RANGE_LEX_ORDERING);
        return new RegularImmutableSortedMap(regularImmutableSortedSet, this.values);
    }

    public int hashCode() {
        return ((ImmutableMap)this.asMapOfRanges()).hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof RangeMap) {
            RangeMap rangeMap = (RangeMap)object;
            return ((ImmutableMap)this.asMapOfRanges()).equals(rangeMap.asMapOfRanges());
        }
        return false;
    }

    public String toString() {
        return ((ImmutableMap)this.asMapOfRanges()).toString();
    }

    public static final class Builder<K extends Comparable<?>, V> {
        private final RangeSet<K> keyRanges = TreeRangeSet.create();
        private final RangeMap<K, V> rangeMap = TreeRangeMap.create();

        public Builder<K, V> put(Range<K> range, V v) {
            Preconditions.checkNotNull(range);
            Preconditions.checkNotNull(v);
            Preconditions.checkArgument(!range.isEmpty(), "Range must not be empty, but was %s", range);
            if (!this.keyRanges.complement().encloses(range)) {
                for (Map.Entry<Range<K>, V> entry : this.rangeMap.asMapOfRanges().entrySet()) {
                    Range<K> range2 = entry.getKey();
                    if (!range2.isConnected(range) || range2.intersection(range).isEmpty()) continue;
                    String string = String.valueOf(String.valueOf(range));
                    String string2 = String.valueOf(String.valueOf(entry));
                    throw new IllegalArgumentException(new StringBuilder(47 + string.length() + string2.length()).append("Overlapping ranges: range ").append(string).append(" overlaps with entry ").append(string2).toString());
                }
            }
            this.keyRanges.add(range);
            this.rangeMap.put(range, v);
            return this;
        }

        public ImmutableRangeMap<K, V> build() {
            Map<Range<K>, V> map = this.rangeMap.asMapOfRanges();
            ImmutableList.Builder builder = new ImmutableList.Builder(map.size());
            ImmutableList.Builder builder2 = new ImmutableList.Builder(map.size());
            for (Map.Entry<Range<K>, V> entry : map.entrySet()) {
                builder.add(entry.getKey());
                builder2.add(entry.getValue());
            }
            return new ImmutableRangeMap(builder.build(), builder2.build());
        }
    }
}

