/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import com.github.tmurakami.dexopener.ClassPath;
import com.github.tmurakami.dexopener.Loggers;
import java.util.logging.Level;
import java.util.logging.Logger;

class ClassInjector
extends ClassLoader {
    private final ClassLoader target;
    private final ClassPath classPath;

    ClassInjector(ClassLoader target, ClassPath classPath) {
        super(target.getParent());
        this.target = target;
        this.classPath = classPath;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class c = this.classPath.loadClass(name, this.target);
        if (c == null) {
            return super.findClass(name);
        }
        Logger logger = Loggers.get();
        if (logger.isLoggable(Level.FINEST)) {
            String hash = Integer.toHexString(System.identityHashCode(this.target));
            String target = this.target.getClass().getName() + '@' + hash;
            logger.finest("The " + name + " was injected into the " + target + " class loader");
        }
        return c;
    }
}

