/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Predicate;
import java.util.HashSet;
import java.util.Set;

final class ClassNameFilter
implements Predicate<String> {
    private static final String[] INCLUDED_PACKAGES = new String[]{"android.databinding.generated."};
    private static final String[] INCLUDED_CLASSES = new String[]{"android.databinding.DataBinderMapper", "android.databinding.DataBindingComponent", "android.databinding.DataBindingUtil"};
    private final String packagePrefix;
    private final Set<String> excludedClassNames;

    ClassNameFilter(String rootPackage, Class ... excludedClasses) {
        String packagePrefix;
        this.packagePrefix = packagePrefix = rootPackage + '.';
        HashSet<String> classes = new HashSet<String>();
        for (Class c : excludedClasses) {
            String className = c.getName();
            if (!className.startsWith(packagePrefix)) continue;
            classes.add(className);
        }
        this.excludedClassNames = classes;
    }

    public boolean apply(String className) {
        for (String pkg : INCLUDED_PACKAGES) {
            if (!className.startsWith(pkg)) continue;
            return true;
        }
        for (String cls : INCLUDED_CLASSES) {
            if (!className.equals(cls)) continue;
            return true;
        }
        return className.startsWith(this.packagePrefix) && !className.endsWith(".BR") && !className.endsWith(".BuildConfig") && !className.endsWith(".R") && !className.contains(".R$") && !this.excludedClassNames.contains(className);
    }
}

