/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import com.github.tmurakami.dexopener.DexFileLoader;
import com.github.tmurakami.dexopener.FileUtils;
import com.github.tmurakami.dexopener.FinalModifierRemoverModule;
import com.github.tmurakami.dexopener.Loggers;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcodes;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.ClassDef;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.DexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.rewriter.DexRewriter;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.rewriter.RewriterModule;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.io.DexDataStore;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.io.FileDataStore;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.DexPool;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ClassTransformationTask
implements Callable<dalvik.system.DexFile>,
DexFile {
    private final Opcodes opcodes;
    private final File codeCacheDir;
    private final DexFileLoader dexFileLoader;
    private Set<? extends ClassDef> classes;

    ClassTransformationTask(Opcodes opcodes, Set<? extends ClassDef> classes, File codeCacheDir, DexFileLoader dexFileLoader) {
        this.opcodes = opcodes;
        this.classes = classes;
        this.codeCacheDir = codeCacheDir;
        this.dexFileLoader = dexFileLoader;
    }

    public Opcodes getOpcodes() {
        return this.opcodes;
    }

    public Set<? extends ClassDef> getClasses() {
        return this.classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public dalvik.system.DexFile call() throws IOException {
        DexRewriter dexRewriter = new DexRewriter((RewriterModule)new FinalModifierRemoverModule());
        try {
            dalvik.system.DexFile file;
            DexFile dexFile = dexRewriter.rewriteDexFile((DexFile)this);
            File dex = File.createTempFile("classes", ".dex", this.codeCacheDir);
            dex.deleteOnExit();
            String dexPath = dex.getCanonicalPath();
            File tmp = new File(this.codeCacheDir, dex.getName() + ".tmp.dex");
            String tmpPath = tmp.getCanonicalPath();
            try {
                DexPool.writeTo((DexDataStore)new FileDataStore(tmp), (DexFile)dexFile);
                file = this.dexFileLoader.loadDex(tmpPath, dexPath);
            }
            catch (Throwable throwable) {
                FileUtils.delete(tmp);
                throw throwable;
            }
            FileUtils.delete(tmp);
            Logger logger = Loggers.get();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("A dex file generated: " + dexPath);
            }
            dalvik.system.DexFile dexFile2 = file;
            return dexFile2;
        }
        finally {
            this.classes = Collections.emptySet();
        }
    }
}

