/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import android.content.Context;
import android.os.Build;
import com.github.tmurakami.dexopener.ClassTransformationTask;
import com.github.tmurakami.dexopener.DexFileLoader;
import com.github.tmurakami.dexopener.FileUtils;
import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Function;
import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Functions;
import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Predicate;
import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Predicates;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Iterables;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Maps;
import com.github.tmurakami.dexopener.repackaged.com.google.common.io.ByteStreams;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcodes;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedDexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.ClassDef;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.DexFile;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class ClassPath {
    private static final int MAX_CLASSES_PER_DEX_FILE = 100;
    private final Context context;
    private final Predicate<? super String> classNameFilter;
    private final DexFileLoader dexFileLoader;
    private final Executor executor;
    private Map<String, dalvik.system.DexFile> dexFileMap;

    ClassPath(Context context, Predicate<? super String> classNameFilter, DexFileLoader dexFileLoader, Executor executor) {
        this.context = context;
        this.classNameFilter = classNameFilter;
        this.dexFileLoader = dexFileLoader;
        this.executor = executor;
    }

    Class loadClass(String className, ClassLoader loader) {
        dalvik.system.DexFile dexFile;
        if (this.classNameFilter.apply((Object)className) && (dexFile = this.getDexFileMap().get(className)) != null) {
            return dexFile.loadClass(className, loader);
        }
        return null;
    }

    private Map<String, dalvik.system.DexFile> getDexFileMap() {
        if (this.dexFileMap != null) {
            return this.dexFileMap;
        }
        try {
            this.dexFileMap = this.collectDexFiles();
            return this.dexFileMap;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, dalvik.system.DexFile> collectDexFiles() throws IOException {
        File codeCacheDir = ClassPath.getCodeCacheDir(this.context);
        Function<ClassDef, String> classDefToClassName = ClassPath.classDefToJavaName();
        Predicate classFilter = Predicates.compose(this.classNameFilter, classDefToClassName);
        HashMap taskMap = new HashMap();
        String sourceDir = this.context.getApplicationInfo().sourceDir;
        try (ZipFile zipFile = new ZipFile(sourceDir);){
            for (DexFile dexFile : ClassPath.dexFiles(zipFile)) {
                Opcodes opcodes = dexFile.getOpcodes();
                Iterable classes = Iterables.filter((Iterable)dexFile.getClasses(), (Predicate)classFilter);
                for (List list : Iterables.partition((Iterable)classes, (int)100)) {
                    HashSet set = new HashSet(list);
                    ClassTransformationTask task = new ClassTransformationTask(opcodes, set, codeCacheDir, this.dexFileLoader);
                    FutureTask<dalvik.system.DexFile> future = new FutureTask<dalvik.system.DexFile>(task);
                    this.executor.execute(future);
                    taskMap.putAll(Maps.toMap((Iterable)Iterables.transform(set, classDefToClassName), (Function)Functions.constant(future)));
                }
            }
        }
        return Maps.transformValues(taskMap, ClassPath.dexFileFutureTaskToDexFile());
    }

    private static File getCodeCacheDir(Context context) {
        File parentDir = Build.VERSION.SDK_INT < 21 ? new File(context.getApplicationInfo().dataDir, "code_cache") : context.getCodeCacheDir();
        File cacheDir = new File(parentDir, "dexopener");
        if (cacheDir.isDirectory() || cacheDir.mkdirs()) {
            FileUtils.delete(cacheDir.listFiles());
        }
        return cacheDir;
    }

    private static Iterable<DexFile> dexFiles(final ZipFile zipFile) {
        return Iterables.transform((Iterable)Iterables.filter(Collections.list(zipFile.entries()), (Predicate)new Predicate<ZipEntry>(){

            public boolean apply(ZipEntry entry) {
                String name = entry.getName();
                return name.startsWith("classes") && name.endsWith(".dex");
            }
        }), (Function)new Function<ZipEntry, DexFile>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public DexFile apply(ZipEntry entry) {
                DexBackedDexFile dexBackedDexFile;
                InputStream in = zipFile.getInputStream(entry);
                try {
                    dexBackedDexFile = new DexBackedDexFile(null, ByteStreams.toByteArray((InputStream)in));
                }
                catch (Throwable throwable) {
                    try {
                        in.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new IOError(e);
                    }
                }
                in.close();
                return dexBackedDexFile;
            }
        });
    }

    private static Function<ClassDef, String> classDefToJavaName() {
        return new Function<ClassDef, String>(){

            public String apply(ClassDef classDef) {
                String type = classDef.getType();
                return type.substring(1, type.length() - 1).replace('/', '.');
            }
        };
    }

    private static Function<FutureTask<dalvik.system.DexFile>, dalvik.system.DexFile> dexFileFutureTaskToDexFile() {
        return new Function<FutureTask<dalvik.system.DexFile>, dalvik.system.DexFile>(){

            public dalvik.system.DexFile apply(FutureTask<dalvik.system.DexFile> task) {
                task.run();
                boolean interrupted = false;
                while (true) {
                    try {
                        dalvik.system.DexFile dexFile = task.get();
                        return dexFile;
                    }
                    catch (InterruptedException e) {
                        try {
                            interrupted = true;
                            continue;
                        }
                        catch (ExecutionException e2) {
                            Throwable cause = e2.getCause();
                            if (cause instanceof RuntimeException) {
                                throw (RuntimeException)cause;
                            }
                            if (cause instanceof Error) {
                                throw (Error)cause;
                            }
                            throw new IllegalStateException(cause);
                        }
                    }
                    break;
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        };
    }
}

