/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.util;

import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Predicate;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableSortedSet;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Ordering;
import com.github.tmurakami.dexopener.repackaged.com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;

public class CollectionUtils {
    public static <T> int lastIndexOf(Iterable<T> iterable, Predicate<? super T> predicate) {
        int n = 0;
        int n2 = -1;
        for (T t : iterable) {
            if (predicate.apply(t)) {
                n2 = n;
            }
            ++n;
        }
        return n2;
    }

    public static <T extends Comparable<? super T>> int compareAsList(Collection<? extends T> collection, Collection<? extends T> collection2) {
        int n = Ints.compare(collection.size(), collection2.size());
        if (n != 0) {
            return n;
        }
        Iterator<T> iterator = collection2.iterator();
        for (Comparable comparable : collection) {
            n = comparable.compareTo(iterator.next());
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    public static <T> int compareAsIterable(Comparator<? super T> comparator, Iterable<? extends T> iterable, Iterable<? extends T> iterable2) {
        Iterator<T> iterator = iterable2.iterator();
        for (T t : iterable) {
            T t2;
            try {
                t2 = iterator.next();
            }
            catch (NoSuchElementException noSuchElementException) {
                return 1;
            }
            int n = comparator.compare(t, t2);
            if (n == 0) continue;
            return n;
        }
        if (iterator.hasNext()) {
            return -1;
        }
        return 0;
    }

    public static <T> boolean isNaturalSortedSet(Iterable<? extends T> iterable) {
        if (iterable instanceof SortedSet) {
            SortedSet sortedSet = (SortedSet)iterable;
            Comparator comparator = sortedSet.comparator();
            return comparator == null || comparator.equals(Ordering.natural());
        }
        return false;
    }

    private static <T> SortedSet<? extends T> toNaturalSortedSet(Collection<? extends T> collection) {
        if (CollectionUtils.isNaturalSortedSet(collection)) {
            return (SortedSet)collection;
        }
        return ImmutableSortedSet.copyOf(collection);
    }

    public static <T extends Comparable<T>> int compareAsSet(Collection<? extends T> collection, Collection<? extends T> collection2) {
        int n = Ints.compare(collection.size(), collection2.size());
        if (n != 0) {
            return n;
        }
        SortedSet<? extends T> sortedSet = CollectionUtils.toNaturalSortedSet(collection);
        SortedSet<? extends T> sortedSet2 = CollectionUtils.toNaturalSortedSet(collection2);
        Iterator<T> iterator = collection2.iterator();
        for (Comparable comparable : collection) {
            n = comparable.compareTo(iterator.next());
            if (n == 0) continue;
            return n;
        }
        return 0;
    }
}

