/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import com.github.tmurakami.dexopener.ClassNameFilter;
import com.github.tmurakami.dexopener.ClassTransformationTask;
import com.github.tmurakami.dexopener.DexClassSource;
import com.github.tmurakami.dexopener.DexFileLoader;
import com.github.tmurakami.dexopener.IOUtils;
import com.github.tmurakami.dexopener.Loggers;
import com.github.tmurakami.dexopener.repackaged.com.github.tmurakami.classinjector.ClassFile;
import com.github.tmurakami.dexopener.repackaged.com.github.tmurakami.classinjector.ClassSource;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcodes;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedDexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.ClassDef;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.DexFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

final class AndroidClassSource
implements ClassSource {
    private static final int MAX_CLASSES_PER_DEX_FILE = 100;
    private final String sourceDir;
    private final ClassNameFilter classNameFilter;
    private final File cacheDir;
    private final DexFileLoader dexFileLoader;
    private final Executor executor;
    private ClassSource delegate;

    AndroidClassSource(String sourceDir, ClassNameFilter classNameFilter, File cacheDir, DexFileLoader dexFileLoader, Executor executor) {
        this.sourceDir = sourceDir;
        this.classNameFilter = classNameFilter;
        this.cacheDir = cacheDir;
        this.dexFileLoader = dexFileLoader;
        this.executor = executor;
    }

    public ClassFile getClassFile(String className) throws IOException {
        return this.classNameFilter.accept(className) ? this.getDelegate().getClassFile(className) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassSource getDelegate() throws IOException {
        ClassSource source = this.delegate;
        if (source != null) {
            return source;
        }
        Logger logger = Loggers.get();
        HashMap<String, RunnableFuture<dalvik.system.DexFile>> futureMap = new HashMap<String, RunnableFuture<dalvik.system.DexFile>>();
        try (ZipInputStream in = new ZipInputStream(new FileInputStream(this.sourceDir));){
            ZipEntry e;
            while ((e = in.getNextEntry()) != null) {
                String name = e.getName();
                if (!name.startsWith("classes") || !name.endsWith(".dex")) continue;
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Reading the entry " + name + " from " + this.sourceDir);
                }
                this.map((DexFile)new DexBackedDexFile(null, IOUtils.readBytes(in)), futureMap);
            }
        }
        if (futureMap.isEmpty()) {
            throw new IllegalStateException("There are no classes to be opened");
        }
        this.delegate = new DexClassSource(futureMap);
        return this.delegate;
    }

    private void map(DexFile dexFile, Map<String, RunnableFuture<dalvik.system.DexFile>> futureMap) {
        Opcodes opcodes = dexFile.getOpcodes();
        Logger logger = Loggers.get();
        HashSet<ClassDef> classesToBeOpened = new HashSet<ClassDef>();
        ClassTransformationTask task = new ClassTransformationTask(opcodes, this.cacheDir, this.dexFileLoader);
        FutureTask<dalvik.system.DexFile> future = new FutureTask<dalvik.system.DexFile>(task);
        for (ClassDef def : dexFile.getClasses()) {
            String dexName = def.getType();
            String className = dexName.substring(1, dexName.length() - 1).replace('/', '.');
            if (!this.classNameFilter.accept(className)) continue;
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("The class to be opened: " + className);
            }
            classesToBeOpened.add(def);
            futureMap.put(className, future);
            if (classesToBeOpened.size() < 100) continue;
            task.setClasses(classesToBeOpened);
            this.executor.execute(future);
            classesToBeOpened = new HashSet();
            task = new ClassTransformationTask(opcodes, this.cacheDir, this.dexFileLoader);
            future = new FutureTask<dalvik.system.DexFile>(task);
        }
        if (!classesToBeOpened.isEmpty()) {
            task.setClasses(classesToBeOpened);
            this.executor.execute(future);
        }
    }
}

