/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import java.util.HashSet;
import java.util.Set;

final class ClassNameFilter {
    private static final String[] INCLUDED_PACKAGES = new String[]{"android.databinding.generated."};
    private static final String[] INCLUDED_CLASSES = new String[]{"android.databinding.DataBinderMapper", "android.databinding.DataBindingComponent", "android.databinding.DataBindingUtil"};
    private final String packagePrefix;
    private final Set<String> excludedClasses = new HashSet<String>();

    ClassNameFilter(String packagePrefix) {
        this.packagePrefix = packagePrefix;
    }

    ClassNameFilter excludeClasses(String ... classNames) {
        for (String className : classNames) {
            if (!className.startsWith(this.packagePrefix)) continue;
            this.excludedClasses.add(className);
        }
        return this;
    }

    boolean accept(String className) {
        for (String pkg : INCLUDED_PACKAGES) {
            if (!className.startsWith(pkg)) continue;
            return true;
        }
        for (String cls : INCLUDED_CLASSES) {
            if (!className.equals(cls)) continue;
            return true;
        }
        return className.startsWith(this.packagePrefix) && !className.endsWith(".BR") && !className.endsWith(".BuildConfig") && !className.endsWith(".R") && !className.contains(".R$") && !this.excludedClasses.contains(className);
    }
}

