/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.support.annotation.NonNull;
import com.github.tmurakami.dexopener.AndroidClassSourceFactory;
import com.github.tmurakami.dexopener.DexOpener;
import com.github.tmurakami.dexopener.FileUtils;
import com.github.tmurakami.dexopener.repackaged.com.github.tmurakami.classinjector.ClassInjector;
import com.github.tmurakami.dexopener.repackaged.com.github.tmurakami.classinjector.ClassSource;
import java.io.File;

final class DexOpenerImpl
extends DexOpener {
    private final Context context;
    private final AndroidClassSourceFactory androidClassSourceFactory;

    DexOpenerImpl(Context context, AndroidClassSourceFactory androidClassSourceFactory) {
        this.context = context;
        this.androidClassSourceFactory = androidClassSourceFactory;
    }

    @Override
    public void installTo(@NonNull ClassLoader target) {
        Context context = this.context;
        if (context.getApplicationContext() != null) {
            throw new IllegalStateException("This method must be called before the Application instance is created");
        }
        ApplicationInfo ai = context.getApplicationInfo();
        File parentDir = Build.VERSION.SDK_INT < 21 ? new File(ai.dataDir, "code_cache") : context.getCodeCacheDir();
        File cacheDir = new File(parentDir, "dexopener");
        if (cacheDir.isDirectory() || cacheDir.mkdirs()) {
            FileUtils.delete(cacheDir.listFiles());
        }
        ClassInjector.from((ClassSource)this.androidClassSourceFactory.newClassSource(ai.sourceDir, cacheDir)).into(target);
    }
}

