/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder;

import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableList;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.ItemWithLocation;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.MethodLocation;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class LocatedItems<T extends ItemWithLocation> {
    private List<T> items = null;

    private List<T> getItems() {
        if (this.items == null) {
            return ImmutableList.of();
        }
        return this.items;
    }

    public Set<T> getModifiableItems(final MethodLocation methodLocation) {
        return new AbstractSet<T>(){

            @Override
            public Iterator<T> iterator() {
                final Iterator iterator = LocatedItems.this.getItems().iterator();
                return new Iterator<T>(){
                    private T currentItem = null;

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public T next() {
                        this.currentItem = (ItemWithLocation)iterator.next();
                        return this.currentItem;
                    }

                    @Override
                    public void remove() {
                        if (this.currentItem != null) {
                            ((ItemWithLocation)this.currentItem).setLocation(null);
                        }
                        iterator.remove();
                    }
                };
            }

            @Override
            public int size() {
                return LocatedItems.this.getItems().size();
            }

            @Override
            public boolean add(T t) {
                if (((ItemWithLocation)t).isPlaced()) {
                    throw new IllegalArgumentException(LocatedItems.this.getAddLocatedItemError());
                }
                ((ItemWithLocation)t).setLocation(methodLocation);
                LocatedItems.this.addItem(t);
                return true;
            }
        };
    }

    private void addItem(T t) {
        if (this.items == null) {
            this.items = new ArrayList<T>(1);
        }
        this.items.add(t);
    }

    protected abstract String getAddLocatedItemError();

    public void mergeItemsIntoNext(MethodLocation methodLocation, LocatedItems<T> locatedItems) {
        if (locatedItems == this) {
            return;
        }
        if (this.items != null) {
            for (ItemWithLocation itemWithLocation : this.items) {
                itemWithLocation.setLocation(methodLocation);
            }
            List<T> list = this.items;
            list.addAll(super.getItems());
            locatedItems.items = list;
            this.items = null;
        }
    }
}

