/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.com.google.common.collect;

import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Platform;

public final class ObjectArrays {
    static final Object[] EMPTY_ARRAY = new Object[0];

    public static <T> T[] newArray(T[] TArray, int n) {
        return Platform.newArray(TArray, n);
    }

    static <T> T[] arraysCopyOf(T[] TArray, int n) {
        T[] TArray2 = ObjectArrays.newArray(TArray, n);
        System.arraycopy(TArray, 0, TArray2, 0, Math.min(TArray.length, n));
        return TArray2;
    }

    static Object[] checkElementsNotNull(Object ... objectArray) {
        return ObjectArrays.checkElementsNotNull(objectArray, objectArray.length);
    }

    static Object[] checkElementsNotNull(Object[] objectArray, int n) {
        for (int i = 0; i < n; ++i) {
            ObjectArrays.checkElementNotNull(objectArray[i], i);
        }
        return objectArray;
    }

    static Object checkElementNotNull(Object object, int n) {
        if (object == null) {
            int n2 = n;
            throw new NullPointerException(new StringBuilder(20).append("at index ").append(n2).toString());
        }
        return object;
    }
}

