/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import android.support.annotation.NonNull;
import com.github.tmurakami.dexopener.AndroidClassSource;
import com.github.tmurakami.dexopener.ClassNameFilter;
import com.github.tmurakami.dexopener.DexFileGenerator;
import com.github.tmurakami.dexopener.repackaged.com.github.tmurakami.classinjector.ClassSource;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcodes;
import java.io.File;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

final class AndroidClassSourceFactory {
    private static final Executor EXECUTOR;
    private final ClassNameFilter classNameFilter;

    AndroidClassSourceFactory(ClassNameFilter classNameFilter) {
        this.classNameFilter = classNameFilter;
    }

    ClassSource newClassSource(String sourceDir, File cacheDir) {
        return new AndroidClassSource(Opcodes.getDefault(), sourceDir, this.classNameFilter, new DexFileGenerator(cacheDir), EXECUTOR);
    }

    static {
        final AtomicInteger count = new AtomicInteger();
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        int nThreads = Math.max(1, Math.min(availableProcessors, 4));
        EXECUTOR = Executors.newFixedThreadPool(nThreads, new ThreadFactory(){

            @Override
            public Thread newThread(@NonNull Runnable r) {
                return new Thread(r, "DexOpener #" + count.incrementAndGet());
            }
        });
    }
}

