/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool;

import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcodes;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.Annotation;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.AnnotationElement;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.ClassDef;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.DexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.Field;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.CallSiteReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.FieldReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.MethodHandleReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.MethodProtoReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.MethodReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.StringReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.TypeReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.AnnotationEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.ArrayEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.BooleanEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.ByteEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.CharEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.DoubleEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.EncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.EnumEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.FieldEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.FloatEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.IntEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.LongEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.MethodEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.MethodHandleEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.MethodTypeEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.ShortEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.StringEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.TypeEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.DexWriter;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.io.DexDataStore;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.AnnotationPool;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.AnnotationSetPool;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.CallSitePool;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.ClassPool;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.EncodedArrayPool;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.FieldPool;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.Markable;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.MethodHandlePool;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.MethodPool;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.PoolClassDef;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.PoolMethod;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.ProtoPool;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.StringPool;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.TypeListPool;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.TypePool;
import com.github.tmurakami.dexopener.repackaged.org.jf.util.ExceptionWithContext;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;

public class DexPool
extends DexWriter<CharSequence, StringReference, CharSequence, TypeReference, MethodProtoReference, FieldReference, MethodReference, PoolClassDef, CallSiteReference, MethodHandleReference, Annotation, Set<? extends Annotation>, TypeListPool.Key<? extends Collection<? extends CharSequence>>, Field, PoolMethod, ArrayEncodedValue, EncodedValue, AnnotationElement, StringPool, TypePool, ProtoPool, FieldPool, MethodPool, ClassPool, CallSitePool, MethodHandlePool, TypeListPool, AnnotationPool, AnnotationSetPool, EncodedArrayPool> {
    private final Markable[] sections;

    public DexPool(Opcodes opcodes) {
        super(opcodes);
        this.sections = new Markable[]{(Markable)((Object)this.stringSection), (Markable)((Object)this.typeSection), (Markable)((Object)this.protoSection), (Markable)((Object)this.fieldSection), (Markable)((Object)this.methodSection), (Markable)((Object)this.classSection), (Markable)((Object)this.typeListSection), (Markable)((Object)this.annotationSection), (Markable)((Object)this.annotationSetSection)};
    }

    @Override
    protected DexWriter.SectionProvider getSectionProvider() {
        return new DexPoolSectionProvider();
    }

    public static void writeTo(DexDataStore dexDataStore, DexFile dexFile) throws IOException {
        DexPool dexPool = new DexPool(dexFile.getOpcodes());
        for (ClassDef classDef : dexFile.getClasses()) {
            dexPool.internClass(classDef);
        }
        dexPool.writeTo(dexDataStore);
    }

    public void internClass(ClassDef classDef) {
        ((ClassPool)this.classSection).intern(classDef);
    }

    @Override
    protected void writeEncodedValue(DexWriter.InternalEncodedValueWriter internalEncodedValueWriter, EncodedValue encodedValue) throws IOException {
        switch (encodedValue.getValueType()) {
            case 29: {
                AnnotationEncodedValue annotationEncodedValue = (AnnotationEncodedValue)encodedValue;
                internalEncodedValueWriter.writeAnnotation(annotationEncodedValue.getType(), annotationEncodedValue.getElements());
                break;
            }
            case 28: {
                ArrayEncodedValue arrayEncodedValue = (ArrayEncodedValue)encodedValue;
                internalEncodedValueWriter.writeArray(arrayEncodedValue.getValue());
                break;
            }
            case 31: {
                internalEncodedValueWriter.writeBoolean(((BooleanEncodedValue)encodedValue).getValue());
                break;
            }
            case 0: {
                internalEncodedValueWriter.writeByte(((ByteEncodedValue)encodedValue).getValue());
                break;
            }
            case 3: {
                internalEncodedValueWriter.writeChar(((CharEncodedValue)encodedValue).getValue());
                break;
            }
            case 17: {
                internalEncodedValueWriter.writeDouble(((DoubleEncodedValue)encodedValue).getValue());
                break;
            }
            case 27: {
                internalEncodedValueWriter.writeEnum(((EnumEncodedValue)encodedValue).getValue());
                break;
            }
            case 25: {
                internalEncodedValueWriter.writeField(((FieldEncodedValue)encodedValue).getValue());
                break;
            }
            case 16: {
                internalEncodedValueWriter.writeFloat(((FloatEncodedValue)encodedValue).getValue());
                break;
            }
            case 4: {
                internalEncodedValueWriter.writeInt(((IntEncodedValue)encodedValue).getValue());
                break;
            }
            case 6: {
                internalEncodedValueWriter.writeLong(((LongEncodedValue)encodedValue).getValue());
                break;
            }
            case 26: {
                internalEncodedValueWriter.writeMethod(((MethodEncodedValue)encodedValue).getValue());
                break;
            }
            case 30: {
                internalEncodedValueWriter.writeNull();
                break;
            }
            case 2: {
                internalEncodedValueWriter.writeShort(((ShortEncodedValue)encodedValue).getValue());
                break;
            }
            case 23: {
                internalEncodedValueWriter.writeString(((StringEncodedValue)encodedValue).getValue());
                break;
            }
            case 24: {
                internalEncodedValueWriter.writeType(((TypeEncodedValue)encodedValue).getValue());
                break;
            }
            case 21: {
                internalEncodedValueWriter.writeMethodType(((MethodTypeEncodedValue)encodedValue).getValue());
                break;
            }
            case 22: {
                internalEncodedValueWriter.writeMethodHandle(((MethodHandleEncodedValue)encodedValue).getValue());
                break;
            }
            default: {
                throw new ExceptionWithContext("Unrecognized value type: %d", encodedValue.getValueType());
            }
        }
    }

    void internEncodedValue(EncodedValue encodedValue) {
        switch (encodedValue.getValueType()) {
            case 29: {
                AnnotationEncodedValue annotationEncodedValue = (AnnotationEncodedValue)encodedValue;
                ((TypePool)this.typeSection).intern(annotationEncodedValue.getType());
                for (AnnotationElement annotationElement : annotationEncodedValue.getElements()) {
                    ((StringPool)this.stringSection).intern(annotationElement.getName());
                    this.internEncodedValue(annotationElement.getValue());
                }
                break;
            }
            case 28: {
                for (EncodedValue encodedValue2 : ((ArrayEncodedValue)encodedValue).getValue()) {
                    this.internEncodedValue(encodedValue2);
                }
                break;
            }
            case 23: {
                ((StringPool)this.stringSection).intern(((StringEncodedValue)encodedValue).getValue());
                break;
            }
            case 24: {
                ((TypePool)this.typeSection).intern(((TypeEncodedValue)encodedValue).getValue());
                break;
            }
            case 27: {
                ((FieldPool)this.fieldSection).intern(((EnumEncodedValue)encodedValue).getValue());
                break;
            }
            case 25: {
                ((FieldPool)this.fieldSection).intern(((FieldEncodedValue)encodedValue).getValue());
                break;
            }
            case 26: {
                ((MethodPool)this.methodSection).intern(((MethodEncodedValue)encodedValue).getValue());
                break;
            }
            case 22: {
                ((MethodHandlePool)this.methodHandleSection).intern(((MethodHandleEncodedValue)encodedValue).getValue());
                break;
            }
            case 21: {
                ((ProtoPool)this.protoSection).intern(((MethodTypeEncodedValue)encodedValue).getValue());
            }
        }
    }

    protected class DexPoolSectionProvider
    extends DexWriter.SectionProvider {
        protected DexPoolSectionProvider() {
        }

        public StringPool getStringSection() {
            return new StringPool(DexPool.this);
        }

        public TypePool getTypeSection() {
            return new TypePool(DexPool.this);
        }

        public ProtoPool getProtoSection() {
            return new ProtoPool(DexPool.this);
        }

        public FieldPool getFieldSection() {
            return new FieldPool(DexPool.this);
        }

        public MethodPool getMethodSection() {
            return new MethodPool(DexPool.this);
        }

        public ClassPool getClassSection() {
            return new ClassPool(DexPool.this);
        }

        public CallSitePool getCallSiteSection() {
            return new CallSitePool(DexPool.this);
        }

        public MethodHandlePool getMethodHandleSection() {
            return new MethodHandlePool(DexPool.this);
        }

        public TypeListPool getTypeListSection() {
            return new TypeListPool(DexPool.this);
        }

        public AnnotationPool getAnnotationSection() {
            return new AnnotationPool(DexPool.this);
        }

        public AnnotationSetPool getAnnotationSetSection() {
            return new AnnotationSetPool(DexPool.this);
        }

        public EncodedArrayPool getEncodedArraySection() {
            return new EncodedArrayPool(DexPool.this);
        }
    }
}

