/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.support.annotation.NonNull;
import com.github.tmurakami.dexopener.AndroidClassSourceFactory;
import com.github.tmurakami.dexopener.DexOpener;
import com.github.tmurakami.dexopener.FileUtils;
import com.github.tmurakami.dexopener.repackaged.com.github.tmurakami.classinjector.ClassInjector;
import com.github.tmurakami.dexopener.repackaged.com.github.tmurakami.classinjector.ClassSource;
import java.io.File;

final class DexOpenerImpl
extends DexOpener {
    private final Context context;
    private final AndroidClassSourceFactory androidClassSourceFactory;

    DexOpenerImpl(Context context, AndroidClassSourceFactory androidClassSourceFactory) {
        this.context = context;
        this.androidClassSourceFactory = androidClassSourceFactory;
    }

    @Override
    public void installTo(@NonNull ClassLoader target) {
        Context context = this.context;
        ApplicationInfo ai = context.getApplicationInfo();
        if (context.getApplicationContext() != null) {
            throw new IllegalStateException("This method must be called before the Application instance is created");
        }
        File cacheDir = new File(DexOpenerImpl.getCodeCacheDir(context), "dexopener");
        if (cacheDir.isDirectory()) {
            FileUtils.delete(cacheDir.listFiles());
        }
        ClassInjector.from((ClassSource)this.androidClassSourceFactory.newClassSource(ai.sourceDir, cacheDir)).into(target);
    }

    private static File getCodeCacheDir(Context context) {
        if (Build.VERSION.SDK_INT >= 21) {
            return context.getCodeCacheDir();
        }
        String parentName = "code_cache";
        File dir = new File(context.getApplicationInfo().dataDir, parentName);
        return dir.mkdir() || dir.isDirectory() ? dir : new File(context.getFilesDir(), parentName);
    }
}

