/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import com.github.tmurakami.dexopener.DexFileHolder;
import dalvik.system.DexFile;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableFuture;

final class DexFileHolderImpl
implements DexFileHolder {
    private RunnableFuture<? extends DexFile> dexFileFuture;

    DexFileHolderImpl() {
    }

    void setDexFileFuture(RunnableFuture<? extends DexFile> dexFileFuture) {
        this.dexFileFuture = dexFileFuture;
    }

    @Override
    public DexFile get() throws IOException {
        this.dexFileFuture.run();
        boolean interrupted = false;
        while (true) {
            try {
                DexFile dexFile = (DexFile)this.dexFileFuture.get();
                return dexFile;
            }
            catch (InterruptedException e) {
                try {
                    interrupted = true;
                    continue;
                }
                catch (ExecutionException e2) {
                    Throwable cause = e2.getCause();
                    if (cause instanceof IOException) {
                        throw (IOException)cause;
                    }
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    if (cause instanceof Error) {
                        throw (Error)cause;
                    }
                    throw new UndeclaredThrowableException(cause, "Unexpected error");
                }
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

