/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool;

import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Function;
import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Predicate;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.FluentIterable;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableList;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Iterables;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Ordering;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.MutableMethodImplementation;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.Annotation;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.ClassDef;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.ExceptionHandler;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.Field;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.Method;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.MethodImplementation;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.MethodParameter;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.TryBlock;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.debug.DebugItem;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.debug.EndLocal;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.debug.LineNumber;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.debug.RestartLocal;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.debug.SetSourceFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.debug.StartLocal;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.Instruction;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.ReferenceInstruction;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.CallSiteReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.FieldReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.MethodReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.Reference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.StringReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.TypeReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.ArrayEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.EncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.util.ReferenceUtil;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.ClassSection;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.DebugWriter;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.AnnotationSetPool;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.BasePool;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.CallSitePool;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.DexPool;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.EncodedArrayPool;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.FieldPool;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.MethodPool;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.PoolClassDef;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.PoolMethod;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.StringPool;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.TypeListPool;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.TypePool;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.util.StaticInitializerUtil;
import com.github.tmurakami.dexopener.repackaged.org.jf.util.AbstractForwardSequentialList;
import com.github.tmurakami.dexopener.repackaged.org.jf.util.ExceptionWithContext;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;

public class ClassPool
extends BasePool<String, PoolClassDef>
implements ClassSection<CharSequence, CharSequence, TypeListPool.Key<? extends Collection<? extends CharSequence>>, PoolClassDef, Field, PoolMethod, Set<? extends Annotation>, ArrayEncodedValue> {
    private ImmutableList<PoolClassDef> sortedClasses = null;
    private static final Predicate<MethodParameter> HAS_PARAMETER_ANNOTATIONS = new Predicate<MethodParameter>(){

        @Override
        public boolean apply(MethodParameter methodParameter) {
            return methodParameter.getAnnotations().size() > 0;
        }
    };
    private static final Function<MethodParameter, Set<? extends Annotation>> PARAMETER_ANNOTATIONS = new Function<MethodParameter, Set<? extends Annotation>>(){

        @Override
        public Set<? extends Annotation> apply(MethodParameter methodParameter) {
            return methodParameter.getAnnotations();
        }
    };

    public ClassPool(DexPool dexPool) {
        super(dexPool);
    }

    public void intern(ClassDef classDef) {
        Object object;
        PoolClassDef poolClassDef = new PoolClassDef(classDef);
        PoolClassDef poolClassDef2 = this.internedItems.put(poolClassDef.getType(), poolClassDef);
        if (poolClassDef2 != null) {
            throw new ExceptionWithContext("Class %s has already been interned", poolClassDef.getType());
        }
        ((TypePool)this.dexPool.typeSection).intern(poolClassDef.getType());
        ((TypePool)this.dexPool.typeSection).internNullable(poolClassDef.getSuperclass());
        ((TypeListPool)this.dexPool.typeListSection).intern(poolClassDef.getInterfaces());
        ((StringPool)this.dexPool.stringSection).internNullable(poolClassDef.getSourceFile());
        HashSet<String> hashSet = new HashSet<String>();
        for (Field object2 : poolClassDef.getFields()) {
            Object object3 = ReferenceUtil.getShortFieldDescriptor(object2);
            if (!hashSet.add((String)object3)) {
                throw new ExceptionWithContext("Multiple definitions for field %s->%s", poolClassDef.getType(), object3);
            }
            ((FieldPool)this.dexPool.fieldSection).intern(object2);
            object = object2.getInitialValue();
            if (object != null) {
                this.dexPool.internEncodedValue((EncodedValue)object);
            }
            ((AnnotationSetPool)this.dexPool.annotationSetSection).intern(object2.getAnnotations());
            ArrayEncodedValue arrayEncodedValue = this.getStaticInitializers(poolClassDef);
            if (arrayEncodedValue == null) continue;
            ((EncodedArrayPool)this.dexPool.encodedArraySection).intern(arrayEncodedValue);
        }
        HashSet hashSet2 = new HashSet();
        for (Object object3 : poolClassDef.getMethods()) {
            object = ReferenceUtil.getMethodDescriptor((MethodReference)object3, true);
            if (!hashSet2.add(object)) {
                throw new ExceptionWithContext("Multiple definitions for method %s->%s", poolClassDef.getType(), object);
            }
            ((MethodPool)this.dexPool.methodSection).intern((MethodReference)object3);
            this.internCode((Method)object3);
            this.internDebug((Method)object3);
            ((AnnotationSetPool)this.dexPool.annotationSetSection).intern(((PoolMethod)object3).getAnnotations());
            for (MethodParameter methodParameter : ((PoolMethod)object3).getParameters()) {
                ((AnnotationSetPool)this.dexPool.annotationSetSection).intern(methodParameter.getAnnotations());
            }
        }
        ((AnnotationSetPool)this.dexPool.annotationSetSection).intern(poolClassDef.getAnnotations());
    }

    private void internCode(Method method) {
        boolean bl = false;
        MethodImplementation methodImplementation = method.getImplementation();
        if (methodImplementation != null) {
            block7: for (Instruction object : methodImplementation.getInstructions()) {
                bl = true;
                if (!(object instanceof ReferenceInstruction)) continue;
                Reference reference = ((ReferenceInstruction)object).getReference();
                switch (object.getOpcode().referenceType) {
                    case 0: {
                        ((StringPool)this.dexPool.stringSection).intern((StringReference)reference);
                        continue block7;
                    }
                    case 1: {
                        ((TypePool)this.dexPool.typeSection).intern((TypeReference)reference);
                        continue block7;
                    }
                    case 2: {
                        ((FieldPool)this.dexPool.fieldSection).intern((FieldReference)reference);
                        continue block7;
                    }
                    case 3: {
                        ((MethodPool)this.dexPool.methodSection).intern((MethodReference)reference);
                        continue block7;
                    }
                    case 5: {
                        ((CallSitePool)this.dexPool.callSiteSection).intern((CallSiteReference)reference);
                        continue block7;
                    }
                }
                throw new ExceptionWithContext("Unrecognized reference type: %d", object.getOpcode().referenceType);
            }
            List<? extends TryBlock<? extends ExceptionHandler>> list = methodImplementation.getTryBlocks();
            if (!bl && list.size() > 0) {
                throw new ExceptionWithContext("Method %s has no instructions, but has try blocks.", ReferenceUtil.getMethodDescriptor(method));
            }
            for (TryBlock<? extends ExceptionHandler> tryBlock : methodImplementation.getTryBlocks()) {
                for (ExceptionHandler exceptionHandler : tryBlock.getExceptionHandlers()) {
                    ((TypePool)this.dexPool.typeSection).internNullable(exceptionHandler.getExceptionType());
                }
            }
        }
    }

    private void internDebug(Method method) {
        for (MethodParameter object : method.getParameters()) {
            String string = object.getName();
            if (string == null) continue;
            ((StringPool)this.dexPool.stringSection).intern(string);
        }
        MethodImplementation methodImplementation = method.getImplementation();
        if (methodImplementation != null) {
            for (DebugItem debugItem : methodImplementation.getDebugItems()) {
                switch (debugItem.getDebugItemType()) {
                    case 3: {
                        StartLocal startLocal = (StartLocal)debugItem;
                        ((StringPool)this.dexPool.stringSection).internNullable(startLocal.getName());
                        ((TypePool)this.dexPool.typeSection).internNullable(startLocal.getType());
                        ((StringPool)this.dexPool.stringSection).internNullable(startLocal.getSignature());
                        break;
                    }
                    case 9: {
                        ((StringPool)this.dexPool.stringSection).internNullable(((SetSourceFile)debugItem).getSourceFile());
                    }
                }
            }
        }
    }

    @Override
    public Collection<? extends PoolClassDef> getSortedClasses() {
        if (this.sortedClasses == null) {
            this.sortedClasses = Ordering.natural().immutableSortedCopy(this.internedItems.values());
        }
        return this.sortedClasses;
    }

    @Override
    public Map.Entry<? extends PoolClassDef, Integer> getClassEntryByType(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        final PoolClassDef poolClassDef = (PoolClassDef)this.internedItems.get(charSequence.toString());
        if (poolClassDef == null) {
            return null;
        }
        return new Map.Entry<PoolClassDef, Integer>(){

            @Override
            public PoolClassDef getKey() {
                return poolClassDef;
            }

            @Override
            public Integer getValue() {
                return poolClassDef.classDefIndex;
            }

            @Override
            public Integer setValue(Integer n) {
                poolClassDef.classDefIndex = n;
                return poolClassDef.classDefIndex;
            }
        };
    }

    @Override
    public CharSequence getType(PoolClassDef poolClassDef) {
        return poolClassDef.getType();
    }

    @Override
    public int getAccessFlags(PoolClassDef poolClassDef) {
        return poolClassDef.getAccessFlags();
    }

    @Override
    public CharSequence getSuperclass(PoolClassDef poolClassDef) {
        return poolClassDef.getSuperclass();
    }

    @Override
    public TypeListPool.Key<List<String>> getInterfaces(PoolClassDef poolClassDef) {
        return poolClassDef.interfaces;
    }

    @Override
    public CharSequence getSourceFile(PoolClassDef poolClassDef) {
        return poolClassDef.getSourceFile();
    }

    @Override
    public ArrayEncodedValue getStaticInitializers(PoolClassDef poolClassDef) {
        return StaticInitializerUtil.getStaticInitializers((SortedSet<? extends Field>)poolClassDef.getStaticFields());
    }

    @Override
    public Collection<? extends Field> getSortedStaticFields(PoolClassDef poolClassDef) {
        return poolClassDef.getStaticFields();
    }

    @Override
    public Collection<? extends Field> getSortedInstanceFields(PoolClassDef poolClassDef) {
        return poolClassDef.getInstanceFields();
    }

    @Override
    public Collection<? extends Field> getSortedFields(PoolClassDef poolClassDef) {
        return poolClassDef.getFields();
    }

    @Override
    public Collection<PoolMethod> getSortedDirectMethods(PoolClassDef poolClassDef) {
        return poolClassDef.getDirectMethods();
    }

    @Override
    public Collection<PoolMethod> getSortedVirtualMethods(PoolClassDef poolClassDef) {
        return poolClassDef.getVirtualMethods();
    }

    @Override
    public Collection<? extends PoolMethod> getSortedMethods(PoolClassDef poolClassDef) {
        return poolClassDef.getMethods();
    }

    @Override
    public int getFieldAccessFlags(Field field) {
        return field.getAccessFlags();
    }

    @Override
    public int getMethodAccessFlags(PoolMethod poolMethod) {
        return poolMethod.getAccessFlags();
    }

    @Override
    public Set<? extends Annotation> getClassAnnotations(PoolClassDef poolClassDef) {
        Set<? extends Annotation> set = poolClassDef.getAnnotations();
        if (set.size() == 0) {
            return null;
        }
        return set;
    }

    @Override
    public Set<? extends Annotation> getFieldAnnotations(Field field) {
        Set<? extends Annotation> set = field.getAnnotations();
        if (set.size() == 0) {
            return null;
        }
        return set;
    }

    @Override
    public Set<? extends Annotation> getMethodAnnotations(PoolMethod poolMethod) {
        Set<? extends Annotation> set = poolMethod.getAnnotations();
        if (set.size() == 0) {
            return null;
        }
        return set;
    }

    @Override
    public List<? extends Set<? extends Annotation>> getParameterAnnotations(PoolMethod poolMethod) {
        final List<? extends MethodParameter> list = poolMethod.getParameters();
        boolean bl = Iterables.any(list, HAS_PARAMETER_ANNOTATIONS);
        if (bl) {
            return new AbstractForwardSequentialList<Set<? extends Annotation>>(){

                @Override
                public Iterator<Set<? extends Annotation>> iterator() {
                    return FluentIterable.from(list).transform(PARAMETER_ANNOTATIONS).iterator();
                }

                @Override
                public int size() {
                    return list.size();
                }
            };
        }
        return null;
    }

    @Override
    public Iterable<? extends DebugItem> getDebugItems(PoolMethod poolMethod) {
        MethodImplementation methodImplementation = poolMethod.getImplementation();
        if (methodImplementation != null) {
            return methodImplementation.getDebugItems();
        }
        return null;
    }

    @Override
    public Iterable<CharSequence> getParameterNames(PoolMethod poolMethod) {
        return Iterables.transform(poolMethod.getParameters(), new Function<MethodParameter, CharSequence>(){

            @Override
            public CharSequence apply(MethodParameter methodParameter) {
                return methodParameter.getName();
            }
        });
    }

    @Override
    public int getRegisterCount(PoolMethod poolMethod) {
        MethodImplementation methodImplementation = poolMethod.getImplementation();
        if (methodImplementation != null) {
            return methodImplementation.getRegisterCount();
        }
        return 0;
    }

    @Override
    public Iterable<? extends Instruction> getInstructions(PoolMethod poolMethod) {
        MethodImplementation methodImplementation = poolMethod.getImplementation();
        if (methodImplementation != null) {
            return methodImplementation.getInstructions();
        }
        return null;
    }

    @Override
    public List<? extends TryBlock<? extends ExceptionHandler>> getTryBlocks(PoolMethod poolMethod) {
        MethodImplementation methodImplementation = poolMethod.getImplementation();
        if (methodImplementation != null) {
            return methodImplementation.getTryBlocks();
        }
        return ImmutableList.of();
    }

    @Override
    public CharSequence getExceptionType(ExceptionHandler exceptionHandler) {
        return exceptionHandler.getExceptionType();
    }

    @Override
    public MutableMethodImplementation makeMutableMethodImplementation(PoolMethod poolMethod) {
        return new MutableMethodImplementation(poolMethod.getImplementation());
    }

    @Override
    public void setAnnotationDirectoryOffset(PoolClassDef poolClassDef, int n) {
        poolClassDef.annotationDirectoryOffset = n;
    }

    @Override
    public int getAnnotationDirectoryOffset(PoolClassDef poolClassDef) {
        return poolClassDef.annotationDirectoryOffset;
    }

    @Override
    public void setAnnotationSetRefListOffset(PoolMethod poolMethod, int n) {
        poolMethod.annotationSetRefListOffset = n;
    }

    @Override
    public int getAnnotationSetRefListOffset(PoolMethod poolMethod) {
        return poolMethod.annotationSetRefListOffset;
    }

    @Override
    public void setCodeItemOffset(PoolMethod poolMethod, int n) {
        poolMethod.codeItemOffset = n;
    }

    @Override
    public int getCodeItemOffset(PoolMethod poolMethod) {
        return poolMethod.codeItemOffset;
    }

    @Override
    public void writeDebugItem(DebugWriter<CharSequence, CharSequence> debugWriter, DebugItem debugItem) throws IOException {
        switch (debugItem.getDebugItemType()) {
            case 3: {
                StartLocal startLocal = (StartLocal)debugItem;
                debugWriter.writeStartLocal(startLocal.getCodeAddress(), startLocal.getRegister(), startLocal.getName(), startLocal.getType(), startLocal.getSignature());
                break;
            }
            case 5: {
                EndLocal endLocal = (EndLocal)debugItem;
                debugWriter.writeEndLocal(endLocal.getCodeAddress(), endLocal.getRegister());
                break;
            }
            case 6: {
                RestartLocal restartLocal = (RestartLocal)debugItem;
                debugWriter.writeRestartLocal(restartLocal.getCodeAddress(), restartLocal.getRegister());
                break;
            }
            case 7: {
                debugWriter.writePrologueEnd(debugItem.getCodeAddress());
                break;
            }
            case 8: {
                debugWriter.writeEpilogueBegin(debugItem.getCodeAddress());
                break;
            }
            case 10: {
                LineNumber lineNumber = (LineNumber)debugItem;
                debugWriter.writeLineNumber(lineNumber.getCodeAddress(), lineNumber.getLineNumber());
                break;
            }
            case 9: {
                SetSourceFile setSourceFile = (SetSourceFile)debugItem;
                debugWriter.writeSetSourceFile(setSourceFile.getCodeAddress(), setSourceFile.getSourceFile());
            }
            default: {
                throw new ExceptionWithContext("Unexpected debug item type: %d", debugItem.getDebugItemType());
            }
        }
    }

    @Override
    public int getItemIndex(PoolClassDef poolClassDef) {
        return poolClassDef.classDefIndex;
    }

    @Override
    public Collection<? extends Map.Entry<PoolClassDef, Integer>> getItems() {
        return new AbstractCollection<Map.Entry<PoolClassDef, Integer>>(){

            @Override
            public Iterator<Map.Entry<PoolClassDef, Integer>> iterator() {
                return new Iterator<Map.Entry<PoolClassDef, Integer>>(){
                    Iterator<PoolClassDef> iter;
                    {
                        this.iter = ClassPool.this.internedItems.values().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public Map.Entry<PoolClassDef, Integer> next() {
                        class MapEntry
                        implements Map.Entry<PoolClassDef, Integer> {
                            private final PoolClassDef classDef;

                            public MapEntry(PoolClassDef poolClassDef) {
                                this.classDef = poolClassDef;
                            }

                            @Override
                            public PoolClassDef getKey() {
                                return this.classDef;
                            }

                            @Override
                            public Integer getValue() {
                                return this.classDef.classDefIndex;
                            }

                            @Override
                            public Integer setValue(Integer n) {
                                int n2 = this.classDef.classDefIndex;
                                this.classDef.classDefIndex = n;
                                return n2;
                            }
                        }
                        return new MapEntry(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return ClassPool.this.internedItems.size();
            }
        };
    }
}

