/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.instruction;

import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Format;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcode;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction22t;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.instruction.ImmutableInstruction;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.util.Preconditions;

public class ImmutableInstruction22t
extends ImmutableInstruction
implements Instruction22t {
    public static final Format FORMAT = Format.Format22t;
    protected final int registerA;
    protected final int registerB;
    protected final int codeOffset;

    public ImmutableInstruction22t(Opcode opcode, int n, int n2, int n3) {
        super(opcode);
        this.registerA = Preconditions.checkNibbleRegister(n);
        this.registerB = Preconditions.checkNibbleRegister(n2);
        this.codeOffset = Preconditions.checkShortCodeOffset(n3);
    }

    public static ImmutableInstruction22t of(Instruction22t instruction22t) {
        if (instruction22t instanceof ImmutableInstruction22t) {
            return (ImmutableInstruction22t)instruction22t;
        }
        return new ImmutableInstruction22t(instruction22t.getOpcode(), instruction22t.getRegisterA(), instruction22t.getRegisterB(), instruction22t.getCodeOffset());
    }

    @Override
    public int getRegisterA() {
        return this.registerA;
    }

    @Override
    public int getRegisterB() {
        return this.registerB;
    }

    @Override
    public int getCodeOffset() {
        return this.codeOffset;
    }

    @Override
    public Format getFormat() {
        return FORMAT;
    }
}

