/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.com.google.common.collect;

import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Preconditions;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.DescendingImmutableSortedSet;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.EmptyImmutableSortedSet;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableCollection;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableList;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableSet;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableSortedSetFauxverideShim;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Iterables;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Iterators;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ObjectArrays;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Ordering;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.RegularImmutableSortedSet;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.SortedIterable;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.SortedIterables;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.UnmodifiableIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;

public abstract class ImmutableSortedSet<E>
extends ImmutableSortedSetFauxverideShim<E>
implements SortedIterable<E>,
NavigableSet<E> {
    private static final Comparator<Comparable> NATURAL_ORDER = Ordering.natural();
    private static final ImmutableSortedSet<Comparable> NATURAL_EMPTY_SET = new EmptyImmutableSortedSet<Comparable>(NATURAL_ORDER);
    final transient Comparator<? super E> comparator;
    transient ImmutableSortedSet<E> descendingSet;

    private static <E> ImmutableSortedSet<E> emptySet() {
        return NATURAL_EMPTY_SET;
    }

    static <E> ImmutableSortedSet<E> emptySet(Comparator<? super E> comparator) {
        if (NATURAL_ORDER.equals(comparator)) {
            return ImmutableSortedSet.emptySet();
        }
        return new EmptyImmutableSortedSet<E>(comparator);
    }

    public static <E> ImmutableSortedSet<E> of() {
        return ImmutableSortedSet.emptySet();
    }

    public static <E> ImmutableSortedSet<E> copyOf(Iterable<? extends E> iterable) {
        Ordering ordering = Ordering.natural();
        return ImmutableSortedSet.copyOf(ordering, iterable);
    }

    public static <E> ImmutableSortedSet<E> copyOf(Collection<? extends E> collection) {
        Ordering ordering = Ordering.natural();
        return ImmutableSortedSet.copyOf(ordering, collection);
    }

    public static <E> ImmutableSortedSet<E> copyOf(Comparator<? super E> comparator, Iterator<? extends E> iterator) {
        return ((Builder)new Builder<E>(comparator).addAll((Iterator)iterator)).build();
    }

    public static <E> ImmutableSortedSet<E> copyOf(Comparator<? super E> comparator, Iterable<? extends E> iterable) {
        Object object;
        Preconditions.checkNotNull(comparator);
        boolean bl = SortedIterables.hasSameComparator(comparator, iterable);
        if (bl && iterable instanceof ImmutableSortedSet && !((ImmutableCollection)(object = (ImmutableSortedSet)iterable)).isPartialView()) {
            return object;
        }
        object = Iterables.toArray(iterable);
        return ImmutableSortedSet.construct(comparator, ((Object[])object).length, object);
    }

    public static <E> ImmutableSortedSet<E> copyOf(Comparator<? super E> comparator, Collection<? extends E> collection) {
        return ImmutableSortedSet.copyOf(comparator, collection);
    }

    static <E> ImmutableSortedSet<E> construct(Comparator<? super E> comparator, int n, E ... EArray) {
        if (n == 0) {
            return ImmutableSortedSet.emptySet(comparator);
        }
        ObjectArrays.checkElementsNotNull((Object[])EArray, n);
        Arrays.sort(EArray, 0, n, comparator);
        int n2 = 1;
        for (int i = 1; i < n; ++i) {
            E e = EArray[i];
            E e2 = EArray[n2 - 1];
            if (comparator.compare(e, e2) == 0) continue;
            EArray[n2++] = e;
        }
        Arrays.fill(EArray, n2, n, null);
        return new RegularImmutableSortedSet<E>(ImmutableList.asImmutableList(EArray, n2), comparator);
    }

    int unsafeCompare(Object object, Object object2) {
        return ImmutableSortedSet.unsafeCompare(this.comparator, object, object2);
    }

    static int unsafeCompare(Comparator<?> comparator, Object object, Object object2) {
        Comparator<?> comparator2 = comparator;
        return comparator2.compare(object, object2);
    }

    ImmutableSortedSet(Comparator<? super E> comparator) {
        this.comparator = comparator;
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    @Override
    public abstract UnmodifiableIterator<E> iterator();

    @Override
    public ImmutableSortedSet<E> headSet(E e) {
        return this.headSet((Object)e, false);
    }

    @Override
    public ImmutableSortedSet<E> headSet(E e, boolean bl) {
        return this.headSetImpl(Preconditions.checkNotNull(e), bl);
    }

    @Override
    public ImmutableSortedSet<E> subSet(E e, E e2) {
        return this.subSet((Object)e, true, (Object)e2, false);
    }

    @Override
    public ImmutableSortedSet<E> subSet(E e, boolean bl, E e2, boolean bl2) {
        Preconditions.checkNotNull(e);
        Preconditions.checkNotNull(e2);
        Preconditions.checkArgument(this.comparator.compare(e, e2) <= 0);
        return this.subSetImpl(e, bl, e2, bl2);
    }

    @Override
    public ImmutableSortedSet<E> tailSet(E e) {
        return this.tailSet((Object)e, true);
    }

    @Override
    public ImmutableSortedSet<E> tailSet(E e, boolean bl) {
        return this.tailSetImpl(Preconditions.checkNotNull(e), bl);
    }

    abstract ImmutableSortedSet<E> headSetImpl(E var1, boolean var2);

    abstract ImmutableSortedSet<E> subSetImpl(E var1, boolean var2, E var3, boolean var4);

    abstract ImmutableSortedSet<E> tailSetImpl(E var1, boolean var2);

    @Override
    public E lower(E e) {
        return Iterators.getNext(((ImmutableSortedSet)this.headSet((Object)e, false)).descendingIterator(), null);
    }

    @Override
    public E floor(E e) {
        return Iterators.getNext(((ImmutableSortedSet)this.headSet((Object)e, true)).descendingIterator(), null);
    }

    @Override
    public E ceiling(E e) {
        return Iterables.getFirst(this.tailSet((Object)e, true), null);
    }

    @Override
    public E higher(E e) {
        return Iterables.getFirst(this.tailSet((Object)e, false), null);
    }

    @Override
    public E first() {
        return this.iterator().next();
    }

    @Override
    public E last() {
        return this.descendingIterator().next();
    }

    @Override
    public final E pollFirst() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final E pollLast() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ImmutableSortedSet<E> descendingSet() {
        ImmutableSortedSet<E> immutableSortedSet = this.descendingSet;
        if (immutableSortedSet == null) {
            immutableSortedSet = this.descendingSet = this.createDescendingSet();
            immutableSortedSet.descendingSet = this;
        }
        return immutableSortedSet;
    }

    ImmutableSortedSet<E> createDescendingSet() {
        return new DescendingImmutableSortedSet(this);
    }

    @Override
    public abstract UnmodifiableIterator<E> descendingIterator();

    abstract int indexOf(Object var1);

    public static final class Builder<E>
    extends ImmutableSet.Builder<E> {
        private final Comparator<? super E> comparator;

        public Builder(Comparator<? super E> comparator) {
            this.comparator = Preconditions.checkNotNull(comparator);
        }

        @Override
        public Builder<E> add(E e) {
            super.add((Object)e);
            return this;
        }

        @Override
        public Builder<E> addAll(Iterator<? extends E> iterator) {
            super.addAll((Iterator)iterator);
            return this;
        }

        @Override
        public ImmutableSortedSet<E> build() {
            Object[] objectArray = this.contents;
            ImmutableSortedSet<Object> immutableSortedSet = ImmutableSortedSet.construct(this.comparator, this.size, objectArray);
            this.size = immutableSortedSet.size();
            return immutableSortedSet;
        }
    }
}

