/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.com.google.common.base;

import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Joiner;
import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Preconditions;
import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Predicate;
import java.io.Serializable;
import java.util.Collection;

public final class Predicates {
    private static final Joiner COMMA_JOINER = Joiner.on(',');

    public static <T> Predicate<T> isNull() {
        return ObjectPredicate.IS_NULL.withNarrowedType();
    }

    public static <T> Predicate<T> equalTo(T t) {
        return t == null ? Predicates.isNull() : new IsEqualToPredicate(t);
    }

    public static <T> Predicate<T> in(Collection<? extends T> collection) {
        return new InPredicate(collection);
    }

    private static class InPredicate<T>
    implements Predicate<T>,
    Serializable {
        private final Collection<?> target;

        private InPredicate(Collection<?> collection) {
            this.target = Preconditions.checkNotNull(collection);
        }

        @Override
        public boolean apply(T t) {
            try {
                return this.target.contains(t);
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        public boolean equals(Object object) {
            if (object instanceof InPredicate) {
                InPredicate inPredicate = (InPredicate)object;
                return this.target.equals(inPredicate.target);
            }
            return false;
        }

        public int hashCode() {
            return this.target.hashCode();
        }

        public String toString() {
            String string = String.valueOf(String.valueOf(this.target));
            return new StringBuilder(15 + string.length()).append("Predicates.in(").append(string).append(")").toString();
        }
    }

    private static class IsEqualToPredicate<T>
    implements Predicate<T>,
    Serializable {
        private final T target;

        private IsEqualToPredicate(T t) {
            this.target = t;
        }

        @Override
        public boolean apply(T t) {
            return this.target.equals(t);
        }

        public int hashCode() {
            return this.target.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof IsEqualToPredicate) {
                IsEqualToPredicate isEqualToPredicate = (IsEqualToPredicate)object;
                return this.target.equals(isEqualToPredicate.target);
            }
            return false;
        }

        public String toString() {
            String string = String.valueOf(String.valueOf(this.target));
            return new StringBuilder(20 + string.length()).append("Predicates.equalTo(").append(string).append(")").toString();
        }
    }

    static abstract class ObjectPredicate
    extends Enum<ObjectPredicate>
    implements Predicate<Object> {
        public static final /* enum */ ObjectPredicate ALWAYS_TRUE = new ObjectPredicate(){

            @Override
            public boolean apply(Object object) {
                return true;
            }

            public String toString() {
                return "Predicates.alwaysTrue()";
            }
        };
        public static final /* enum */ ObjectPredicate ALWAYS_FALSE = new ObjectPredicate(){

            @Override
            public boolean apply(Object object) {
                return false;
            }

            public String toString() {
                return "Predicates.alwaysFalse()";
            }
        };
        public static final /* enum */ ObjectPredicate IS_NULL = new ObjectPredicate(){

            @Override
            public boolean apply(Object object) {
                return object == null;
            }

            public String toString() {
                return "Predicates.isNull()";
            }
        };
        public static final /* enum */ ObjectPredicate NOT_NULL = new ObjectPredicate(){

            @Override
            public boolean apply(Object object) {
                return object != null;
            }

            public String toString() {
                return "Predicates.notNull()";
            }
        };
        private static final /* synthetic */ ObjectPredicate[] $VALUES;

        <T> Predicate<T> withNarrowedType() {
            return this;
        }

        static {
            $VALUES = new ObjectPredicate[]{ALWAYS_TRUE, ALWAYS_FALSE, IS_NULL, NOT_NULL};
        }
    }
}

