/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.instruction;

import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Format;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcode;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction21lh;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.instruction.ImmutableInstruction;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.util.Preconditions;

public class ImmutableInstruction21lh
extends ImmutableInstruction
implements Instruction21lh {
    public static final Format FORMAT = Format.Format21lh;
    protected final int registerA;
    protected final long literal;

    public ImmutableInstruction21lh(Opcode opcode, int n, long l) {
        super(opcode);
        this.registerA = Preconditions.checkByteRegister(n);
        this.literal = Preconditions.checkLongHatLiteral(l);
    }

    public static ImmutableInstruction21lh of(Instruction21lh instruction21lh) {
        if (instruction21lh instanceof ImmutableInstruction21lh) {
            return (ImmutableInstruction21lh)instruction21lh;
        }
        return new ImmutableInstruction21lh(instruction21lh.getOpcode(), instruction21lh.getRegisterA(), instruction21lh.getWideLiteral());
    }

    @Override
    public int getRegisterA() {
        return this.registerA;
    }

    @Override
    public long getWideLiteral() {
        return this.literal;
    }

    @Override
    public short getHatLiteral() {
        return (short)(this.literal >>> 48);
    }

    @Override
    public Format getFormat() {
        return FORMAT;
    }
}

