/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable;

import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableList;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.base.BaseTryBlock;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.ExceptionHandler;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.TryBlock;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.ImmutableExceptionHandler;
import com.github.tmurakami.dexopener.repackaged.org.jf.util.ImmutableConverter;
import java.util.List;

public class ImmutableTryBlock
extends BaseTryBlock<ImmutableExceptionHandler> {
    protected final int startCodeAddress;
    protected final int codeUnitCount;
    protected final ImmutableList<? extends ImmutableExceptionHandler> exceptionHandlers;
    private static final ImmutableConverter<ImmutableTryBlock, TryBlock<? extends ExceptionHandler>> CONVERTER = new ImmutableConverter<ImmutableTryBlock, TryBlock<? extends ExceptionHandler>>(){

        @Override
        protected boolean isImmutable(TryBlock tryBlock) {
            return tryBlock instanceof ImmutableTryBlock;
        }

        @Override
        protected ImmutableTryBlock makeImmutable(TryBlock<? extends ExceptionHandler> tryBlock) {
            return ImmutableTryBlock.of(tryBlock);
        }
    };

    public ImmutableTryBlock(int n, int n2, List<? extends ExceptionHandler> list) {
        this.startCodeAddress = n;
        this.codeUnitCount = n2;
        this.exceptionHandlers = ImmutableExceptionHandler.immutableListOf(list);
    }

    public static ImmutableTryBlock of(TryBlock<? extends ExceptionHandler> tryBlock) {
        if (tryBlock instanceof ImmutableTryBlock) {
            return (ImmutableTryBlock)tryBlock;
        }
        return new ImmutableTryBlock(tryBlock.getStartCodeAddress(), tryBlock.getCodeUnitCount(), tryBlock.getExceptionHandlers());
    }

    @Override
    public int getStartCodeAddress() {
        return this.startCodeAddress;
    }

    @Override
    public int getCodeUnitCount() {
        return this.codeUnitCount;
    }

    @Override
    public ImmutableList<? extends ImmutableExceptionHandler> getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    public static ImmutableList<ImmutableTryBlock> immutableListOf(List<? extends TryBlock<? extends ExceptionHandler>> list) {
        return CONVERTER.toList(list);
    }
}

