/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import com.github.tmurakami.dexopener.FileUtils;
import com.github.tmurakami.dexopener.FinalModifierRemoverModule;
import com.github.tmurakami.dexopener.Loggers;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.DexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.rewriter.DexRewriter;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.rewriter.RewriterModule;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.io.DexDataStore;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.io.FileDataStore;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.DexPool;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;

final class DexFileOpener {
    private final Executor executor;
    private final File cacheDir;

    DexFileOpener(Executor executor, File cacheDir) {
        this.executor = executor;
        this.cacheDir = cacheDir;
    }

    RunnableFuture<dalvik.system.DexFile> openDexFile(DexFile dexFile) {
        OpenDexFile openDexFile = new OpenDexFile(dexFile, this.cacheDir);
        FutureTask<dalvik.system.DexFile> future = new FutureTask<dalvik.system.DexFile>(openDexFile);
        this.executor.execute(future);
        return future;
    }

    private static class OpenDexFile
    implements Callable<dalvik.system.DexFile> {
        private DexFile dexFile;
        private final File cacheDir;

        OpenDexFile(DexFile dexFile, File cacheDir) {
            this.dexFile = dexFile;
            this.cacheDir = cacheDir;
        }

        @Override
        public dalvik.system.DexFile call() throws IOException {
            DexRewriter dexRewriter = new DexRewriter((RewriterModule)new FinalModifierRemoverModule());
            try {
                dalvik.system.DexFile dexFile = OpenDexFile.generateDexFile(dexRewriter.rewriteDexFile(this.dexFile), this.cacheDir);
                return dexFile;
            }
            finally {
                this.dexFile = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static dalvik.system.DexFile generateDexFile(DexFile dexFile, File cacheDir) throws IOException {
            dalvik.system.DexFile file;
            if (!cacheDir.isDirectory() && !cacheDir.mkdirs()) {
                throw new IOException("Cannot create " + cacheDir);
            }
            File dex = File.createTempFile("classes", ".dex", cacheDir);
            dex.deleteOnExit();
            String dexPath = dex.getCanonicalPath();
            File tmp = new File(cacheDir, dex.getName() + ".tmp.dex");
            String tmpPath = tmp.getCanonicalPath();
            try {
                DexPool.writeTo((DexDataStore)new FileDataStore(tmp), (DexFile)dexFile);
                file = dalvik.system.DexFile.loadDex((String)tmpPath, (String)dexPath, (int)0);
            }
            catch (Throwable throwable) {
                FileUtils.delete(tmp);
                throw throwable;
            }
            FileUtils.delete(tmp);
            Logger logger = Loggers.get();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("DEX file generated: " + dexPath);
            }
            return file;
        }
    }
}

