/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.util;

import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableList;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableSet;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableSortedSet;
import java.util.Comparator;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class ImmutableConverter<ImmutableItem, Item> {
    protected abstract boolean isImmutable(@Nonnull Item var1);

    @Nonnull
    protected abstract ImmutableItem makeImmutable(@Nonnull Item var1);

    @Nonnull
    public ImmutableList<ImmutableItem> toList(@Nullable Iterable<? extends Item> iterable) {
        if (iterable == null) {
            return ImmutableList.of();
        }
        boolean needsCopy = false;
        if (iterable instanceof ImmutableList) {
            for (Item element : iterable) {
                if (this.isImmutable(element)) continue;
                needsCopy = true;
                break;
            }
        } else {
            needsCopy = true;
        }
        if (!needsCopy) {
            return (ImmutableList)iterable;
        }
        final Iterator<? extends Item> iter = iterable.iterator();
        return ImmutableList.copyOf(new Iterator<ImmutableItem>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public ImmutableItem next() {
                return ImmutableConverter.this.makeImmutable(iter.next());
            }

            @Override
            public void remove() {
                iter.remove();
            }
        });
    }

    @Nonnull
    public ImmutableSet<ImmutableItem> toSet(@Nullable Iterable<? extends Item> iterable) {
        if (iterable == null) {
            return ImmutableSet.of();
        }
        boolean needsCopy = false;
        if (iterable instanceof ImmutableSet) {
            for (Item element : iterable) {
                if (this.isImmutable(element)) continue;
                needsCopy = true;
                break;
            }
        } else {
            needsCopy = true;
        }
        if (!needsCopy) {
            return (ImmutableSet)iterable;
        }
        final Iterator<? extends Item> iter = iterable.iterator();
        return ImmutableSet.copyOf(new Iterator<ImmutableItem>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public ImmutableItem next() {
                return ImmutableConverter.this.makeImmutable(iter.next());
            }

            @Override
            public void remove() {
                iter.remove();
            }
        });
    }

    @Nonnull
    public ImmutableSortedSet<ImmutableItem> toSortedSet(@Nonnull Comparator<? super ImmutableItem> comparator, @Nullable Iterable<? extends Item> iterable) {
        if (iterable == null) {
            return ImmutableSortedSet.of();
        }
        boolean needsCopy = false;
        if (iterable instanceof ImmutableSortedSet && ((ImmutableSortedSet)iterable).comparator().equals(comparator)) {
            for (Item element : iterable) {
                if (this.isImmutable(element)) continue;
                needsCopy = true;
                break;
            }
        } else {
            needsCopy = true;
        }
        if (!needsCopy) {
            return (ImmutableSortedSet)iterable;
        }
        final Iterator<? extends Item> iter = iterable.iterator();
        return ImmutableSortedSet.copyOf(comparator, new Iterator<ImmutableItem>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public ImmutableItem next() {
                return ImmutableConverter.this.makeImmutable(iter.next());
            }

            @Override
            public void remove() {
                iter.remove();
            }
        });
    }
}

